/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.ec.injvm;

import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.ec.EventCenter;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.ec.EventSubscriber;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class InjvmEventCenter
implements EventCenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventCenter.class.getName());
    private final ConcurrentHashMap<String, Set<EventSubscriber>> ecMap = new ConcurrentHashMap();
    private final ExecutorService executor = Executors.newFixedThreadPool(Constants.AVAILABLE_PROCESSOR * 2, new NamedThreadFactory("LTS-InjvmEventCenter-Executor", true));

    @Override
    public void subscribe(EventSubscriber subscriber, String ... topics) {
        for (String topic : topics) {
            Set<EventSubscriber> oldSubscribers;
            Set<EventSubscriber> subscribers = this.ecMap.get(topic);
            if (subscribers == null && (oldSubscribers = this.ecMap.putIfAbsent(topic, subscribers = new ConcurrentHashSet<EventSubscriber>())) != null) {
                subscribers = oldSubscribers;
            }
            subscribers.add(subscriber);
        }
    }

    @Override
    public void unSubscribe(String topic, EventSubscriber subscriber) {
        Set<EventSubscriber> subscribers = this.ecMap.get(topic);
        if (subscribers != null) {
            for (EventSubscriber eventSubscriber : subscribers) {
                if (!eventSubscriber.getId().equals(subscriber.getId())) continue;
                subscribers.remove(eventSubscriber);
            }
        }
    }

    @Override
    public void publishSync(EventInfo eventInfo) {
        Set<EventSubscriber> subscribers = this.ecMap.get(eventInfo.getTopic());
        if (subscribers != null) {
            for (EventSubscriber subscriber : subscribers) {
                eventInfo.setTopic(eventInfo.getTopic());
                try {
                    subscriber.getObserver().onObserved(eventInfo);
                }
                catch (Throwable t) {
                    LOGGER.error(" eventInfo:{}, subscriber:{}", JSON.toJSONString(eventInfo), JSON.toJSONString(subscriber), t);
                }
            }
        }
    }

    @Override
    public void publishAsync(final EventInfo eventInfo) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                String topic = eventInfo.getTopic();
                Set subscribers = (Set)InjvmEventCenter.this.ecMap.get(topic);
                if (subscribers != null) {
                    for (EventSubscriber subscriber : subscribers) {
                        try {
                            eventInfo.setTopic(topic);
                            subscriber.getObserver().onObserved(eventInfo);
                        }
                        catch (Throwable t) {
                            LOGGER.error(" eventInfo:{}, subscriber:{}", JSON.toJSONString(eventInfo), JSON.toJSONString(subscriber), t);
                        }
                    }
                }
            }
        });
    }
}

