/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.pkg.dslplatform.json;

import com.github.loki4j.pkg.dslplatform.json.RawJsonWriter;

public class NumberConverter {
    private static final byte MINUS = 45;
    private static final byte ZERO = 48;
    private static final byte[] DIGITS = new byte[40];

    public static void serialize(long value, RawJsonWriter sw) {
        long num = value;
        if (num == 0L) {
            sw.writeByte((byte)48);
            return;
        }
        if (num < 0L) {
            sw.writeByte((byte)45);
            num = -num;
        }
        int pos = 0;
        while (num != 0L) {
            NumberConverter.DIGITS[pos++] = (byte)(num % 10L);
            num /= 10L;
        }
        while (pos > 0) {
            byte digit = (byte)(48 + DIGITS[--pos]);
            sw.writeByte(digit);
        }
    }
}

