/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.languageselector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeService;
import org.liveSense.core.Configurator;
import org.liveSense.service.languageselector.LanguageSelectorService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, label="%language.servlet.name", description="%language.servlet.description")
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/session/language"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class LanguageSelectorServlet
extends HttpServlet {
    private static final long serialVersionUID = 8016477105020492838L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    LanguageSelectorService languageSelector;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    Configurator configurator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    MimeTypeService mimeTypeService;
    static final int DEFAULT_BUFFER_SIZE = 4096;
    static final String STORE_TYPE_COOKIE = "cookie";
    static final String STORE_TYPE_SESSION = "session";
    private final Logger log = LoggerFactory.getLogger(LanguageSelectorServlet.class);
    public static final String PARAM_STORE_TYPE = "storeType";
    public static final String DEFAULT_STORE_TYPE = "cookie";
    @Property(name="storeType", label="%soreType.name", description="%storeType.description", value={"cookie"})
    private String storeType = "cookie";

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary props = componentContext.getProperties();
        String storeTypeNew = (String)componentContext.getProperties().get(PARAM_STORE_TYPE);
        if (storeTypeNew == null || storeTypeNew.length() == 0) {
            storeTypeNew = "cookie";
        }
        if (!storeTypeNew.equals(this.storeType)) {
            this.log.info("Setting new storeType {} (was {})", (Object)storeTypeNew, (Object)this.storeType);
            this.storeType = storeTypeNew;
        }
    }

    public static long copy(InputStream pInputStream, OutputStream pOutputStream, boolean pClose) throws IOException {
        return LanguageSelectorServlet.copy(pInputStream, pOutputStream, pClose, new byte[4096]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream pIn, OutputStream pOut, boolean pClose, byte[] pBuffer) throws IOException {
        OutputStream out = pOut;
        InputStream in = pIn;
        try {
            int res;
            long total = 0L;
            while ((res = in.read(pBuffer)) != -1) {
                if (res <= 0) continue;
                total += (long)res;
                if (out == null) continue;
                out.write(pBuffer, 0, res);
            }
            if (out != null) {
                if (pClose) {
                    out.close();
                } else {
                    out.flush();
                }
                out = null;
            }
            in.close();
            in = null;
            long l = total;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (pClose && out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String locale = null;
        String type = null;
        String size = null;
        String imageType = null;
        if (request.getParameter("loc") != null) {
            locale = request.getParameter("loc");
        }
        if (request.getParameter("type") != null) {
            type = request.getParameter("type");
        }
        if (request.getParameter("size") != null) {
            size = request.getParameter("size");
        }
        if (request.getParameter("imagetype") != null) {
            imageType = request.getParameter("imagetype");
        }
        if (locale != null && type != null && imageType != null && size != null && type.equalsIgnoreCase("flag")) {
            BufferedInputStream bisr = null;
            try {
                bisr = new BufferedInputStream(this.languageSelector.getFlag(locale, size, imageType));
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (bisr != null) {
                response.setHeader("Cache-Control", "max-age=3600, must-revalidate");
                response.addDateHeader("Expires", System.currentTimeMillis() + 3600000L);
                response.setContentType(this.mimeTypeService.getMimeType(imageType));
                LanguageSelectorServlet.copy(bisr, (OutputStream)response.getOutputStream(), false);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            } else {
                response.sendError(404);
            }
        } else if (request.getParameter("locale") != null) {
            String storeType = this.storeType;
            if (request.getParameter("store") != null) {
                storeType = request.getParameter("store");
            }
            if (storeType.equals("cookie")) {
                Cookie cookie = new Cookie(this.languageSelector.getStoreKeyName(), request.getParameter("locale"));
                if (request.getParameter("domain") != null) {
                    cookie.setDomain(request.getParameter("domain"));
                }
                cookie.setMaxAge(-1);
                cookie.setPath("/");
                cookie.setSecure(request.isSecure());
                response.addCookie(cookie);
            } else if (storeType.equals(STORE_TYPE_SESSION)) {
                request.getSession(true).setAttribute(this.languageSelector.getStoreKeyName(), (Object)request.getParameter("locale"));
            }
        }
        response.getWriter().write("<html><head><meta http-equiv=\"refresh\" content=\"0;url=" + request.getHeader("referer") + "\"/></head><body/></html>");
        response.setContentType("text/html");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    protected void bindLanguageSelector(LanguageSelectorService languageSelectorService) {
        this.languageSelector = languageSelectorService;
    }

    protected void unbindLanguageSelector(LanguageSelectorService languageSelectorService) {
        if (this.languageSelector == languageSelectorService) {
            this.languageSelector = null;
        }
    }

    protected void bindConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    protected void unbindConfigurator(Configurator configurator) {
        if (this.configurator == configurator) {
            this.configurator = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

