/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.languageselector;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.liveSense.core.Configurator;
import org.liveSense.core.wrapper.RequestWrapper;
import org.liveSense.service.languageselector.LanguageSelectorService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, metatype=true, label="%langugae.service.name", description="%language.service.description")
@Service
@Properties(value={@Property(name="languages", label="%languages.name", description="%languages.description", value={"localhost!en_US"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="storeKeyName", label="%storeKey.name", description="%storeKey.description", value={"locale"}), @Property(name="service.vendor", value={"liveSense.org"})})
public class LanguageSelectorServiceImpl
implements LanguageSelectorService {
    private final Logger log = LoggerFactory.getLogger(LanguageSelectorServiceImpl.class);
    public static final String PARAM_LANGUAGES = "languages";
    public static final String DEFAULT_LANGUAGE = "localhost!en_US";
    public static final String[] DEFAULT_LANGUAGES = new String[]{"localhost!en_US"};
    private String[] languages = DEFAULT_LANGUAGES;
    static final String STORE_LOCALE_KEY = "locale";
    public static final String PARAM_STORE_KEY_NAME = "storeKeyName";
    public static final String DEFAULT_STORE_KEY_NAME = "locale";
    private String storeKeyName = "locale";
    private final HashMap<String, HashMap<String, Locale>> langs = new HashMap();
    private final HashMap<String, Locale> domainDefaults = new HashMap();
    private final HashMap<String, HashMap<String, Locale>> customLangs = new HashMap();
    private final HashMap<String, HashMap<String, String>> langNames = new HashMap();
    private final HashMap<String, HashMap<String, String>> countryNames = new HashMap();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    Configurator configurator;
    private Bundle bundle = null;

    @Activate
    protected void activate(ComponentContext componentContext) {
        int i;
        String[] nextLine;
        CSVReader reader;
        Dictionary props = componentContext.getProperties();
        this.bundle = componentContext.getBundleContext().getBundle();
        this.storeKeyName = (String)componentContext.getProperties().get(PARAM_STORE_KEY_NAME);
        this.languages = PropertiesUtil.toStringArray(componentContext.getProperties().get(PARAM_LANGUAGES), (String[])DEFAULT_LANGUAGES);
        this.customLangs.clear();
        this.domainDefaults.clear();
        this.langs.clear();
        for (int i2 = 0; i2 < this.languages.length; ++i2) {
            String act = this.languages[i2];
            String[] domainLangs = act.split("!");
            if (domainLangs.length != 2) continue;
            HashMap<String, Locale> domainLocales = null;
            domainLocales = this.customLangs.get(domainLangs[0]) == null ? new HashMap<String, Locale>() : new HashMap(this.customLangs.get(domainLangs[0]));
            String[] domLocsStr = domainLangs[1].split(",");
            for (int j = 0; j < domLocsStr.length; ++j) {
                String loc = domLocsStr[j];
                domainLocales.put(loc, LanguageSelectorServiceImpl.string2Locale(loc));
                if (j != 0) continue;
                this.domainDefaults.put(domainLangs[0], LanguageSelectorServiceImpl.string2Locale(loc));
            }
            this.langs.put(domainLangs[0], domainLocales);
        }
        URL languageCsvUrl = this.bundle.getEntry("/languages/iso639-1.csv");
        URL countryCsvUrl = this.bundle.getEntry("/countries/iso3166-1.csv");
        if (languageCsvUrl != null) {
            try {
                reader = new CSVReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(languageCsvUrl.openStream()), "UTF-8"));
                boolean firstLine = true;
                String[] colNames = null;
                int index = 0;
                while ((nextLine = reader.readNext()) != null) {
                    if (firstLine) {
                        colNames = (String[])nextLine.clone();
                        for (int i3 = 0; i3 < nextLine.length; ++i3) {
                            if (!nextLine[i3].trim().equalsIgnoreCase("639-1")) continue;
                            index = i3;
                        }
                        firstLine = false;
                        continue;
                    }
                    HashMap<String, String> lang = new HashMap<String, String>();
                    for (i = 0; i < nextLine.length; ++i) {
                        lang.put(colNames[i], nextLine[i]);
                    }
                    this.langNames.put(nextLine[index], lang);
                }
            }
            catch (IOException ex) {
                this.log.error("Error on CSV loading (" + languageCsvUrl.getFile() + ")", (Throwable)ex);
            }
        }
        if (countryCsvUrl != null) {
            try {
                reader = new CSVReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(countryCsvUrl.openStream()), "UTF-8"));
                boolean firstLine = true;
                String[] colNames = null;
                int index = 0;
                while ((nextLine = reader.readNext()) != null) {
                    if (firstLine) {
                        colNames = (String[])nextLine.clone();
                        for (int i4 = 0; i4 < nextLine.length; ++i4) {
                            if (!nextLine[i4].trim().equalsIgnoreCase("alpha-2")) continue;
                            index = i4;
                        }
                        firstLine = false;
                        continue;
                    }
                    HashMap<String, String> country = new HashMap<String, String>();
                    for (i = 0; i < nextLine.length; ++i) {
                        country.put(colNames[i], nextLine[i]);
                    }
                    this.countryNames.put(nextLine[index], country);
                }
            }
            catch (IOException ex) {
                this.log.error("Error on CSV loading (" + countryCsvUrl.getFile() + ")", (Throwable)ex);
            }
        }
    }

    private static Locale string2Locale(String str) {
        Locale ret = null;
        String[] locParts = str.split("_");
        if (locParts.length == 3) {
            ret = new Locale(locParts[0], locParts[1], locParts[2]);
        } else if (locParts.length == 2) {
            ret = new Locale(locParts[0], locParts[1]);
        } else if (locParts.length == 1) {
            ret = new Locale(locParts[0]);
        }
        return ret;
    }

    @Override
    public void addLanguage(String domain, String locale) {
        this.addLanguage(domain, LanguageSelectorServiceImpl.string2Locale(locale));
    }

    @Override
    public void addLanguage(String domain, Locale locale) {
        HashMap<String, Locale> domainLocales;
        HashMap<String, Locale> domainLocalesCustom = this.customLangs.get(domain);
        if (domainLocalesCustom == null) {
            domainLocalesCustom = new HashMap();
            domainLocalesCustom.put(locale.toString(), locale);
            this.customLangs.put(domain, domainLocalesCustom);
        }
        if ((domainLocales = this.langs.get(domain)) == null) {
            domainLocales = new HashMap();
            domainLocales.put(locale.toString(), locale);
            this.langs.put(domain, domainLocalesCustom);
        }
    }

    @Override
    public List<Locale> getAvailableLanguages(String domain) {
        ArrayList<Locale> ret = new ArrayList<Locale>();
        if (this.langs.get(domain) != null) {
            for (Locale locale : this.langs.get(domain).values()) {
                ret.add(locale);
            }
        }
        return ret;
    }

    @Override
    public String getLanguageName(Locale lang, Locale locale) {
        String ret = null;
        HashMap<String, String> langHash = this.langNames.get(lang.getLanguage());
        if (langHash != null && langHash.get(locale.toString()) != null) {
            ret = langHash.get(locale.toString());
        }
        return ret;
    }

    @Override
    public String getLanguageName(String lang, String locale) {
        return this.getLanguageName(LanguageSelectorServiceImpl.string2Locale(lang), LanguageSelectorServiceImpl.string2Locale(locale));
    }

    @Override
    public InputStream getFlag(String locale, String size, String imageType) {
        URL flagImageUrl = this.bundle.getEntry("/countries/flags/" + locale + "." + size + "." + imageType);
        if (flagImageUrl != null) {
            try {
                return flagImageUrl.openStream();
            }
            catch (IOException ex) {
                this.log.error("Cannot get flag: " + flagImageUrl.getFile());
            }
        }
        return null;
    }

    @Override
    public Locale getLocaleByRequest(HttpServletRequest request) {
        RequestWrapper rw = new RequestWrapper(request, this.configurator.getDefaultLocale(), this.storeKeyName);
        return rw.getLocale();
    }

    @Override
    public Locale getLocaleByRequest(HttpServletRequest request, Locale defaultLocale) {
        RequestWrapper rw = new RequestWrapper(request, defaultLocale, this.storeKeyName);
        return rw.getLocale();
    }

    @Override
    public String getStoreKeyName() {
        return this.storeKeyName;
    }

    protected void bindConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    protected void unbindConfigurator(Configurator configurator) {
        if (this.configurator == configurator) {
            this.configurator = null;
        }
    }
}

