/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.qrcode.wrapper;

import com.github.hui.quick.plugin.base.gif.GifDecoder;
import com.github.hui.quick.plugin.qrcode.constants.QuickQrUtil;
import com.github.hui.quick.plugin.qrcode.entity.DotSize;
import com.github.hui.quick.plugin.qrcode.helper.QrCodeRenderHelper;
import com.google.zxing.EncodeHintType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class QrCodeOptions {
    private String msg;
    private Integer w;
    private Integer h;
    private DrawOptions drawOptions;
    private BgImgOptions bgImgOptions;
    private LogoOptions logoOptions;
    private DetectOptions detectOptions;
    private Map<EncodeHintType, Object> hints;
    private String picType;

    public boolean gifQrCode() {
        return this.bgImgOptions != null && this.bgImgOptions.getGifDecoder() != null;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getW() {
        return this.w;
    }

    public void setW(Integer w) {
        this.w = w;
    }

    public Integer getH() {
        return this.h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public DrawOptions getDrawOptions() {
        return this.drawOptions;
    }

    public void setDrawOptions(DrawOptions drawOptions) {
        this.drawOptions = drawOptions;
    }

    public BgImgOptions getBgImgOptions() {
        return this.bgImgOptions;
    }

    public void setBgImgOptions(BgImgOptions bgImgOptions) {
        this.bgImgOptions = bgImgOptions;
    }

    public LogoOptions getLogoOptions() {
        return this.logoOptions;
    }

    public void setLogoOptions(LogoOptions logoOptions) {
        this.logoOptions = logoOptions;
    }

    public DetectOptions getDetectOptions() {
        return this.detectOptions;
    }

    public void setDetectOptions(DetectOptions detectOptions) {
        this.detectOptions = detectOptions;
    }

    public Map<EncodeHintType, Object> getHints() {
        return this.hints;
    }

    public void setHints(Map<EncodeHintType, Object> hints) {
        this.hints = hints;
    }

    public String getPicType() {
        return this.picType;
    }

    public void setPicType(String picType) {
        this.picType = picType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QrCodeOptions options = (QrCodeOptions)o;
        return Objects.equals(this.msg, options.msg) && Objects.equals(this.w, options.w) && Objects.equals(this.h, options.h) && Objects.equals(this.drawOptions, options.drawOptions) && Objects.equals(this.bgImgOptions, options.bgImgOptions) && Objects.equals(this.logoOptions, options.logoOptions) && Objects.equals(this.detectOptions, options.detectOptions) && Objects.equals(this.hints, options.hints) && Objects.equals(this.picType, options.picType);
    }

    public int hashCode() {
        return Objects.hash(this.msg, this.w, this.h, this.drawOptions, this.bgImgOptions, this.logoOptions, this.detectOptions, this.hints, this.picType);
    }

    public String toString() {
        return "QrCodeOptions{msg='" + this.msg + '\'' + ", w=" + this.w + ", h=" + this.h + ", drawOptions=" + this.drawOptions + ", bgImgOptions=" + this.bgImgOptions + ", logoOptions=" + this.logoOptions + ", detectOptions=" + this.detectOptions + ", hints=" + this.hints + ", picType='" + this.picType + '\'' + '}';
    }

    public static enum TxtMode {
        RANDOM,
        ORDER;

    }

    public static enum DrawStyle {
        RECT{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int w, int h, BufferedImage img, String txt) {
                g2d.fillRect(x, y, w, h);
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        }
        ,
        CIRCLE{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int w, int h, BufferedImage img, String txt) {
                g2d.fill(new Ellipse2D.Float(x, y, w, h));
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        }
        ,
        TRIANGLE{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int w, int h, BufferedImage img, String txt) {
                int[] px = new int[]{x, x + (w >> 1), x + w};
                int[] py = new int[]{y + w, y, y + w};
                g2d.fillPolygon(px, py, 3);
            }

            @Override
            public boolean expand(DotSize expandType) {
                return false;
            }
        }
        ,
        DIAMOND{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int size, int h, BufferedImage img, String txt) {
                int cell4 = size >> 2;
                int cell2 = size >> 1;
                int[] px = new int[]{x + cell4, x + size - cell4, x + size, x + cell2, x};
                int[] py = new int[]{y, y, y + cell2, y + size, y + cell2};
                g2d.fillPolygon(px, py, 5);
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        }
        ,
        SEXANGLE{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int size, int h, BufferedImage img, String txt) {
                int add = size >> 2;
                int[] px = new int[]{x + add, x + size - add, x + size, x + size - add, x + add, x};
                int[] py = new int[]{y, y, y + add + add, y + size, y + size, y + add + add};
                g2d.fillPolygon(px, py, 6);
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        }
        ,
        OCTAGON{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int size, int h, BufferedImage img, String txt) {
                int add = size / 3;
                int[] px = new int[]{x + add, x + size - add, x + size, x + size, x + size - add, x + add, x, x};
                int[] py = new int[]{y, y, y + add, y + size - add, y + size, y + size, y + size - add, y + add};
                g2d.fillPolygon(px, py, 8);
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        }
        ,
        IMAGE{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int w, int h, BufferedImage img, String txt) {
                g2d.drawImage(img.getScaledInstance(w, h, 4), x, y, null);
            }

            @Override
            public boolean expand(DotSize expandType) {
                return true;
            }
        }
        ,
        TXT{

            @Override
            public void draw(Graphics2D g2d, int x, int y, int w, int h, BufferedImage img, String txt) {
                Font oldFont = g2d.getFont();
                if (oldFont.getSize() != w) {
                    Font newFont = QuickQrUtil.font(oldFont.getName(), oldFont.getStyle(), w);
                    g2d.setFont(newFont);
                }
                g2d.drawString(txt, x, y + w);
                g2d.setFont(oldFont);
            }

            @Override
            public boolean expand(DotSize dotSize) {
                return dotSize.getRow() == dotSize.getCol();
            }
        };

        private static Map<String, DrawStyle> map;

        public static DrawStyle getDrawStyle(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return RECT;
            }
            DrawStyle style = map.get(name.toUpperCase());
            return style == null ? RECT : style;
        }

        public abstract void draw(Graphics2D var1, int var2, int var3, int var4, int var5, BufferedImage var6, String var7);

        public abstract boolean expand(DotSize var1);

        static {
            map = new HashMap<String, DrawStyle>(10);
            for (DrawStyle style : DrawStyle.values()) {
                map.put(style.name(), style);
            }
        }
    }

    public static enum BgImgStyle {
        OVERRIDE,
        FILL,
        PENETRATE;


        public static BgImgStyle getStyle(String name) {
            return "fill".equalsIgnoreCase(name) ? FILL : OVERRIDE;
        }
    }

    public static enum LogoStyle {
        ROUND,
        NORMAL,
        CIRCLE;


        public static LogoStyle getStyle(String name) {
            return LogoStyle.valueOf(name.toUpperCase());
        }
    }

    public static enum ImgStyle {
        ROUND,
        NORMAL,
        CIRCLE;


        public static ImgStyle getStyle(String name) {
            return ImgStyle.valueOf(name.toUpperCase());
        }
    }

    public static class DrawOptions {
        private Color preColor;
        private Color bgColor;
        private BufferedImage bgImg;
        private DrawStyle drawStyle;
        private String text;
        private String fontName;
        private TxtMode txtMode;
        private int fontStyle;
        private boolean enableScale;
        private boolean diaphaneityFill;
        private Map<DotSize, BufferedImage> imgMapper;
        private ImgStyle qrStyle;
        private Float cornerRadius;

        public BufferedImage getImage(int row, int col) {
            return this.getImage(DotSize.create(row, col));
        }

        public BufferedImage getImage(DotSize dotSize) {
            return this.imgMapper.get(dotSize);
        }

        public String getDrawQrTxt() {
            return QuickQrUtil.qrTxt(this.text, this.txtMode != null && this.txtMode == TxtMode.RANDOM);
        }

        public Color getPreColor() {
            return this.preColor;
        }

        public void setPreColor(Color preColor) {
            this.preColor = preColor;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public BufferedImage getBgImg() {
            return this.bgImg;
        }

        public void setBgImg(BufferedImage bgImg) {
            this.bgImg = bgImg;
        }

        public DrawStyle getDrawStyle() {
            return this.drawStyle;
        }

        public void setDrawStyle(DrawStyle drawStyle) {
            this.drawStyle = drawStyle;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getFontName() {
            return this.fontName;
        }

        public void setFontName(String fontName) {
            this.fontName = fontName;
        }

        public TxtMode getTxtMode() {
            return this.txtMode;
        }

        public void setTxtMode(TxtMode txtMode) {
            this.txtMode = txtMode;
        }

        public int getFontStyle() {
            return this.fontStyle;
        }

        public void setFontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
        }

        public boolean isEnableScale() {
            return this.enableScale;
        }

        public void setEnableScale(boolean enableScale) {
            this.enableScale = enableScale;
        }

        public boolean isDiaphaneityFill() {
            return this.diaphaneityFill;
        }

        public void setDiaphaneityFill(boolean diaphaneityFill) {
            this.diaphaneityFill = diaphaneityFill;
        }

        public Map<DotSize, BufferedImage> getImgMapper() {
            return this.imgMapper;
        }

        public void setImgMapper(Map<DotSize, BufferedImage> imgMapper) {
            this.imgMapper = imgMapper;
        }

        public ImgStyle getQrStyle() {
            return this.qrStyle;
        }

        public void setQrStyle(ImgStyle qrStyle) {
            this.qrStyle = qrStyle;
        }

        public Float getCornerRadius() {
            return this.cornerRadius;
        }

        public void setCornerRadius(Float cornerRadius) {
            this.cornerRadius = cornerRadius;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DrawOptions that = (DrawOptions)o;
            return this.fontStyle == that.fontStyle && this.enableScale == that.enableScale && this.diaphaneityFill == that.diaphaneityFill && Objects.equals(this.preColor, that.preColor) && Objects.equals(this.bgColor, that.bgColor) && Objects.equals(this.bgImg, that.bgImg) && this.drawStyle == that.drawStyle && Objects.equals(this.text, that.text) && Objects.equals(this.fontName, that.fontName) && this.txtMode == that.txtMode && Objects.equals(this.imgMapper, that.imgMapper) && this.qrStyle == that.qrStyle && Objects.equals(this.cornerRadius, that.cornerRadius);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.preColor, this.bgColor, this.bgImg, this.drawStyle, this.text, this.fontName, this.txtMode, this.fontStyle, this.enableScale, this.diaphaneityFill, this.imgMapper, this.qrStyle, this.cornerRadius});
        }

        public String toString() {
            return "DrawOptions{preColor=" + this.preColor + ", bgColor=" + this.bgColor + ", bgImg=" + this.bgImg + ", drawStyle=" + (Object)((Object)this.drawStyle) + ", text='" + this.text + '\'' + ", fontName='" + this.fontName + '\'' + ", txtMode=" + (Object)((Object)this.txtMode) + ", fontStyle=" + this.fontStyle + ", enableScale=" + this.enableScale + ", diaphaneityFill=" + this.diaphaneityFill + ", imgMapper=" + this.imgMapper + ", qrStyle=" + (Object)((Object)this.qrStyle) + ", cornerRadius=" + this.cornerRadius + '}';
        }

        public static DrawOptionsBuilder builder() {
            return new DrawOptionsBuilder();
        }

        public static class DrawOptionsBuilder {
            private Color preColor;
            private Color bgColor;
            private boolean diaphaneityFill;
            private String text;
            private TxtMode txtMode;
            private String fontName;
            private Integer fontStyle;
            private BufferedImage bgImg;
            private DrawStyle drawStyle;
            private boolean enableScale;
            private Map<DotSize, BufferedImage> imgMapper = new HashMap<DotSize, BufferedImage>();
            private ImgStyle qrStyle;
            private Float cornerRadius;

            public DrawOptionsBuilder preColor(Color preColor) {
                this.preColor = preColor;
                return this;
            }

            public DrawOptionsBuilder bgColor(Color bgColor) {
                this.bgColor = bgColor;
                return this;
            }

            public DrawOptionsBuilder diaphaneityFill(boolean fill) {
                this.diaphaneityFill = fill;
                return this;
            }

            public DrawOptionsBuilder bgImg(BufferedImage image) {
                this.bgImg = image;
                return this;
            }

            public DrawOptionsBuilder drawStyle(DrawStyle drawStyle) {
                this.drawStyle = drawStyle;
                return this;
            }

            public DrawOptionsBuilder text(String text) {
                this.text = text;
                return this;
            }

            public DrawOptionsBuilder txtMode(TxtMode txtMode) {
                this.txtMode = txtMode;
                return this;
            }

            public DrawOptionsBuilder fontName(String fontName) {
                this.fontName = fontName;
                return this;
            }

            public DrawOptionsBuilder fontStyle(int fontStyle) {
                this.fontStyle = fontStyle;
                return this;
            }

            public DrawOptionsBuilder enableScale(boolean enableScale) {
                this.enableScale = enableScale;
                return this;
            }

            public DrawOptionsBuilder drawImg(int row, int column, BufferedImage image) {
                this.imgMapper.put(new DotSize(row, column), image);
                return this;
            }

            public DrawOptionsBuilder qrStyle(ImgStyle qrStyle) {
                this.qrStyle = qrStyle;
                return this;
            }

            public DrawOptionsBuilder cornerRadius(Float cornerRadius) {
                this.cornerRadius = cornerRadius;
                return this;
            }

            public DrawOptions build() {
                DrawOptions drawOptions = new DrawOptions();
                drawOptions.setBgColor(this.bgColor);
                drawOptions.setBgImg(this.bgImg);
                drawOptions.setPreColor(this.preColor);
                drawOptions.setDrawStyle(this.drawStyle);
                drawOptions.setEnableScale(this.enableScale);
                drawOptions.setImgMapper(this.imgMapper);
                drawOptions.setDiaphaneityFill(this.diaphaneityFill);
                drawOptions.setText(this.text == null ? QuickQrUtil.DEFAULT_QR_TXT : this.text);
                drawOptions.setTxtMode(this.txtMode == null ? TxtMode.ORDER : this.txtMode);
                drawOptions.setFontName(this.fontName == null ? QuickQrUtil.DEFAULT_FONT_NAME : this.fontName);
                drawOptions.setFontStyle(this.fontStyle == null ? QuickQrUtil.DEFAULT_FONT_STYLE : this.fontStyle);
                drawOptions.setQrStyle(this.qrStyle == null ? ImgStyle.NORMAL : this.qrStyle);
                drawOptions.setCornerRadius(Float.valueOf(this.cornerRadius == null ? 0.125f : this.cornerRadius.floatValue()));
                return drawOptions;
            }
        }
    }

    public static class DetectOptions {
        private Color outColor;
        private Color inColor;
        private BufferedImage detectImg;
        private BufferedImage detectImgLT;
        private BufferedImage detectImgRT;
        private BufferedImage detectImgLD;
        private Boolean special;

        public Boolean getSpecial() {
            return BooleanUtils.isTrue((Boolean)this.special);
        }

        public DetectOptions() {
        }

        public DetectOptions(Color outColor, Color inColor, BufferedImage detectImg, BufferedImage detectImgLT, BufferedImage detectImgRT, BufferedImage detectImgLD, Boolean special) {
            this.outColor = outColor;
            this.inColor = inColor;
            this.detectImg = detectImg;
            this.detectImgLT = detectImgLT;
            this.detectImgRT = detectImgRT;
            this.detectImgLD = detectImgLD;
            this.special = special;
        }

        public Color getOutColor() {
            return this.outColor;
        }

        public void setOutColor(Color outColor) {
            this.outColor = outColor;
        }

        public Color getInColor() {
            return this.inColor;
        }

        public void setInColor(Color inColor) {
            this.inColor = inColor;
        }

        public BufferedImage getDetectImg() {
            return this.detectImg;
        }

        public void setDetectImg(BufferedImage detectImg) {
            this.detectImg = detectImg;
        }

        public BufferedImage getDetectImgLT() {
            return this.detectImgLT;
        }

        public void setDetectImgLT(BufferedImage detectImgLT) {
            this.detectImgLT = detectImgLT;
        }

        public BufferedImage getDetectImgRT() {
            return this.detectImgRT;
        }

        public void setDetectImgRT(BufferedImage detectImgRT) {
            this.detectImgRT = detectImgRT;
        }

        public BufferedImage getDetectImgLD() {
            return this.detectImgLD;
        }

        public void setDetectImgLD(BufferedImage detectImgLD) {
            this.detectImgLD = detectImgLD;
        }

        public void setSpecial(Boolean special) {
            this.special = special;
        }

        public BufferedImage chooseDetectedImg(QrCodeRenderHelper.DetectLocation detectLocation) {
            switch (detectLocation) {
                case LD: {
                    return this.detectImgLD == null ? this.detectImg : this.detectImgLD;
                }
                case LT: {
                    return this.detectImgLT == null ? this.detectImg : this.detectImgLT;
                }
                case RT: {
                    return this.detectImgRT == null ? this.detectImg : this.detectImgRT;
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DetectOptions that = (DetectOptions)o;
            return Objects.equals(this.outColor, that.outColor) && Objects.equals(this.inColor, that.inColor) && Objects.equals(this.detectImg, that.detectImg) && Objects.equals(this.detectImgLT, that.detectImgLT) && Objects.equals(this.detectImgRT, that.detectImgRT) && Objects.equals(this.detectImgLD, that.detectImgLD) && Objects.equals(this.special, that.special);
        }

        public int hashCode() {
            return Objects.hash(this.outColor, this.inColor, this.detectImg, this.detectImgLT, this.detectImgRT, this.detectImgLD, this.special);
        }

        public String toString() {
            return "DetectOptions{outColor=" + this.outColor + ", inColor=" + this.inColor + ", detectImg=" + this.detectImg + ", detectImgLT=" + this.detectImgLT + ", detectImgRT=" + this.detectImgRT + ", detectImgLD=" + this.detectImgLD + ", special=" + this.special + '}';
        }

        public static DetectOptionsBuilder builder() {
            return new DetectOptionsBuilder();
        }

        public static class DetectOptionsBuilder {
            private Color outColor;
            private Color inColor;
            private BufferedImage detectImg;
            private BufferedImage detectImgLT;
            private BufferedImage detectImgRT;
            private BufferedImage detectImgLD;
            private Boolean special;

            public DetectOptionsBuilder outColor(Color outColor) {
                this.outColor = outColor;
                return this;
            }

            public DetectOptionsBuilder inColor(Color inColor) {
                this.inColor = inColor;
                return this;
            }

            public DetectOptionsBuilder detectImg(BufferedImage detectImg) {
                this.detectImg = detectImg;
                return this;
            }

            public DetectOptionsBuilder detectImgLT(BufferedImage detectImgLT) {
                this.detectImgLT = detectImgLT;
                return this;
            }

            public DetectOptionsBuilder detectImgRT(BufferedImage detectImgRT) {
                this.detectImgRT = detectImgRT;
                return this;
            }

            public DetectOptionsBuilder detectImgLD(BufferedImage detectImgLD) {
                this.detectImgLD = detectImgLD;
                return this;
            }

            public DetectOptionsBuilder special(Boolean special) {
                this.special = special;
                return this;
            }

            public DetectOptions build() {
                return new DetectOptions(this.outColor, this.inColor, this.detectImg, this.detectImgLT, this.detectImgRT, this.detectImgLD, this.special);
            }
        }
    }

    public static class BgImgOptions {
        private BufferedImage bgImg;
        private ImgStyle imgStyle;
        private float radius;
        private GifDecoder gifDecoder;
        private int bgW;
        private int bgH;
        private BgImgStyle bgImgStyle;
        private float opacity;
        private int startX;
        private int startY;

        public BgImgOptions() {
        }

        public BgImgOptions(BufferedImage bgImg, ImgStyle imgStyle, float radius, GifDecoder gifDecoder, int bgW, int bgH, BgImgStyle bgImgStyle, float opacity, int startX, int startY) {
            this.bgImg = bgImg;
            this.imgStyle = imgStyle;
            this.radius = radius;
            this.gifDecoder = gifDecoder;
            this.bgW = bgW;
            this.bgH = bgH;
            this.bgImgStyle = bgImgStyle;
            this.opacity = opacity;
            this.startX = startX;
            this.startY = startY;
        }

        public int getBgW() {
            if (this.bgImgStyle == BgImgStyle.FILL && this.bgW == 0) {
                if (this.bgImg != null) {
                    return this.bgImg.getWidth();
                }
                return this.gifDecoder.getFrame(0).getWidth();
            }
            return this.bgW;
        }

        public int getBgH() {
            if (this.bgImgStyle == BgImgStyle.FILL && this.bgH == 0) {
                if (this.bgImg != null) {
                    return this.bgImg.getHeight();
                }
                return this.gifDecoder.getFrame(0).getHeight();
            }
            return this.bgH;
        }

        public BufferedImage getBgImg() {
            return this.bgImg;
        }

        public void setBgImg(BufferedImage bgImg) {
            this.bgImg = bgImg;
        }

        public GifDecoder getGifDecoder() {
            return this.gifDecoder;
        }

        public void setGifDecoder(GifDecoder gifDecoder) {
            this.gifDecoder = gifDecoder;
        }

        public void setBgW(int bgW) {
            this.bgW = bgW;
        }

        public void setBgH(int bgH) {
            this.bgH = bgH;
        }

        public BgImgStyle getBgImgStyle() {
            return this.bgImgStyle;
        }

        public void setBgImgStyle(BgImgStyle bgImgStyle) {
            this.bgImgStyle = bgImgStyle;
        }

        public float getOpacity() {
            return this.opacity;
        }

        public void setOpacity(float opacity) {
            this.opacity = opacity;
        }

        public int getStartX() {
            return this.startX;
        }

        public void setStartX(int startX) {
            this.startX = startX;
        }

        public int getStartY() {
            return this.startY;
        }

        public void setStartY(int startY) {
            this.startY = startY;
        }

        public ImgStyle getImgStyle() {
            return this.imgStyle;
        }

        public void setImgStyle(ImgStyle imgStyle) {
            this.imgStyle = imgStyle;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BgImgOptions that = (BgImgOptions)o;
            return Float.compare(that.radius, this.radius) == 0 && this.bgW == that.bgW && this.bgH == that.bgH && Float.compare(that.opacity, this.opacity) == 0 && this.startX == that.startX && this.startY == that.startY && Objects.equals(this.bgImg, that.bgImg) && this.imgStyle == that.imgStyle && Objects.equals(this.gifDecoder, that.gifDecoder) && this.bgImgStyle == that.bgImgStyle;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.bgImg, this.imgStyle, Float.valueOf(this.radius), this.gifDecoder, this.bgW, this.bgH, this.bgImgStyle, Float.valueOf(this.opacity), this.startX, this.startY});
        }

        public String toString() {
            return "BgImgOptions{bgImg=" + this.bgImg + ", imgStyle=" + (Object)((Object)this.imgStyle) + ", radius=" + this.radius + ", gifDecoder=" + this.gifDecoder + ", bgW=" + this.bgW + ", bgH=" + this.bgH + ", bgImgStyle=" + (Object)((Object)this.bgImgStyle) + ", opacity=" + this.opacity + ", startX=" + this.startX + ", startY=" + this.startY + '}';
        }

        public static BgImgOptionsBuilder builder() {
            return new BgImgOptionsBuilder();
        }

        public static class BgImgOptionsBuilder {
            private BufferedImage bgImg;
            private ImgStyle imgStyle;
            private Float cornerRadius;
            private GifDecoder gifDecoder;
            private int bgW;
            private int bgH;
            private BgImgStyle bgImgStyle;
            private float opacity;
            private int startX;
            private int startY;

            public BgImgOptionsBuilder bgImg(BufferedImage bgImg) {
                this.bgImg = bgImg;
                return this;
            }

            public BgImgOptionsBuilder imgStyle(ImgStyle imgStyle) {
                this.imgStyle = imgStyle;
                return this;
            }

            public BgImgOptionsBuilder cornerRadius(float radius) {
                this.cornerRadius = Float.valueOf(radius);
                return this;
            }

            public BgImgOptionsBuilder gifDecoder(GifDecoder gifDecoder) {
                this.gifDecoder = gifDecoder;
                return this;
            }

            public BgImgOptionsBuilder bgW(int bgW) {
                this.bgW = bgW;
                return this;
            }

            public BgImgOptionsBuilder bgH(int bgH) {
                this.bgH = bgH;
                return this;
            }

            public BgImgOptionsBuilder bgImgStyle(BgImgStyle bgImgStyle) {
                this.bgImgStyle = bgImgStyle;
                return this;
            }

            public BgImgOptionsBuilder opacity(float opacity) {
                this.opacity = opacity;
                return this;
            }

            public BgImgOptionsBuilder startX(int startX) {
                this.startX = startX;
                return this;
            }

            public BgImgOptionsBuilder startY(int startY) {
                this.startY = startY;
                return this;
            }

            public BgImgOptions build() {
                if (this.imgStyle == null) {
                    this.imgStyle = ImgStyle.NORMAL;
                }
                if (this.cornerRadius == null) {
                    this.cornerRadius = Float.valueOf(0.125f);
                }
                return new BgImgOptions(this.bgImg, this.imgStyle, this.cornerRadius.floatValue(), this.gifDecoder, this.bgW, this.bgH, this.bgImgStyle, this.opacity, this.startX, this.startY);
            }
        }
    }

    public static class LogoOptions {
        private BufferedImage logo;
        private LogoStyle logoStyle;
        private int rate;
        private boolean border;
        private Color borderColor;
        private Color outerBorderColor;
        private Float opacity;

        public LogoOptions() {
        }

        public LogoOptions(BufferedImage logo, LogoStyle logoStyle, int rate, boolean border, Color borderColor, Color outerBorderColor, Float opacity) {
            this.logo = logo;
            this.logoStyle = logoStyle;
            this.rate = rate;
            this.border = border;
            this.borderColor = borderColor;
            this.outerBorderColor = outerBorderColor;
            this.opacity = opacity;
        }

        public BufferedImage getLogo() {
            return this.logo;
        }

        public void setLogo(BufferedImage logo) {
            this.logo = logo;
        }

        public LogoStyle getLogoStyle() {
            return this.logoStyle;
        }

        public void setLogoStyle(LogoStyle logoStyle) {
            this.logoStyle = logoStyle;
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int rate) {
            this.rate = rate;
        }

        public boolean isBorder() {
            return this.border;
        }

        public void setBorder(boolean border) {
            this.border = border;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        public Color getOuterBorderColor() {
            return this.outerBorderColor;
        }

        public void setOuterBorderColor(Color outerBorderColor) {
            this.outerBorderColor = outerBorderColor;
        }

        public Float getOpacity() {
            return this.opacity;
        }

        public void setOpacity(Float opacity) {
            this.opacity = opacity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogoOptions that = (LogoOptions)o;
            return this.rate == that.rate && this.border == that.border && Objects.equals(this.logo, that.logo) && this.logoStyle == that.logoStyle && Objects.equals(this.borderColor, that.borderColor) && Objects.equals(this.outerBorderColor, that.outerBorderColor) && Objects.equals(this.opacity, that.opacity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.logo, this.logoStyle, this.rate, this.border, this.borderColor, this.outerBorderColor, this.opacity});
        }

        public String toString() {
            return "LogoOptions{logo=" + this.logo + ", logoStyle=" + (Object)((Object)this.logoStyle) + ", rate=" + this.rate + ", border=" + this.border + ", borderColor=" + this.borderColor + ", outerBorderColor=" + this.outerBorderColor + ", opacity=" + this.opacity + '}';
        }

        public static LogoOptionsBuilder builder() {
            return new LogoOptionsBuilder();
        }

        public static class LogoOptionsBuilder {
            private BufferedImage logo;
            private LogoStyle logoStyle;
            private int rate;
            private boolean border;
            private Color borderColor;
            private Color outerBorderColor;
            private Float opacity;

            public LogoOptionsBuilder logo(BufferedImage logo) {
                this.logo = logo;
                return this;
            }

            public LogoOptionsBuilder logoStyle(LogoStyle logoStyle) {
                this.logoStyle = logoStyle;
                return this;
            }

            public LogoOptionsBuilder rate(int rate) {
                this.rate = rate;
                return this;
            }

            public LogoOptionsBuilder border(boolean border) {
                this.border = border;
                return this;
            }

            public LogoOptionsBuilder borderColor(Color borderColor) {
                this.borderColor = borderColor;
                return this;
            }

            public LogoOptionsBuilder outerBorderColor(Color outerBorderColor) {
                this.outerBorderColor = outerBorderColor;
                return this;
            }

            public LogoOptionsBuilder opacity(Float opacity) {
                this.opacity = opacity;
                return this;
            }

            public LogoOptions build() {
                return new LogoOptions(this.logo, this.logoStyle, this.rate, this.border, this.borderColor, this.outerBorderColor, this.opacity);
            }
        }
    }
}

