/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.qrcode.wrapper;

import com.github.hui.quick.plugin.base.Base64Util;
import com.github.hui.quick.plugin.base.ColorUtil;
import com.github.hui.quick.plugin.base.FileReadUtil;
import com.github.hui.quick.plugin.base.FileWriteUtil;
import com.github.hui.quick.plugin.base.ImageLoadUtil;
import com.github.hui.quick.plugin.base.IoUtil;
import com.github.hui.quick.plugin.base.constants.MediaType;
import com.github.hui.quick.plugin.base.gif.GifDecoder;
import com.github.hui.quick.plugin.base.gif.GifHelper;
import com.github.hui.quick.plugin.qrcode.constants.QuickQrUtil;
import com.github.hui.quick.plugin.qrcode.helper.QrCodeGenerateHelper;
import com.github.hui.quick.plugin.qrcode.wrapper.BitMatrixEx;
import com.github.hui.quick.plugin.qrcode.wrapper.QrCodeOptions;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeGenWrapper {
    public static Builder of(String content) {
        return new Builder().setMsg(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream asGif(QrCodeOptions qrCodeOptions) throws WriterException {
        try {
            BitMatrixEx bitMatrix = QrCodeGenerateHelper.encode(qrCodeOptions);
            List<ImmutablePair<BufferedImage, Integer>> list = QrCodeGenerateHelper.toGifImages(qrCodeOptions, bitMatrix);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GifHelper.saveGif(list, (OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        finally {
            QuickQrUtil.clear();
        }
    }

    private static BufferedImage asBufferedImage(QrCodeOptions qrCodeOptions) throws WriterException, IOException {
        try {
            BitMatrixEx bitMatrix = QrCodeGenerateHelper.encode(qrCodeOptions);
            BufferedImage bufferedImage = QrCodeGenerateHelper.toBufferedImage(qrCodeOptions, bitMatrix);
            return bufferedImage;
        }
        finally {
            QuickQrUtil.clear();
        }
    }

    private static String asString(QrCodeOptions qrCodeOptions) throws WriterException, IOException {
        if (qrCodeOptions.gifQrCode()) {
            try (ByteArrayOutputStream outputStream = QrCodeGenWrapper.asGif(qrCodeOptions);){
                String string = Base64Util.encode((ByteArrayOutputStream)outputStream);
                return string;
            }
        }
        BufferedImage bufferedImage = QrCodeGenWrapper.asBufferedImage(qrCodeOptions);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, qrCodeOptions.getPicType(), outputStream);
            String string = Base64Util.encode((ByteArrayOutputStream)outputStream);
            return string;
        }
    }

    private static boolean asFile(QrCodeOptions qrCodeOptions, String absFileName) throws WriterException, IOException {
        File file = new File(absFileName);
        FileWriteUtil.mkDir((File)file.getParentFile());
        if (qrCodeOptions.gifQrCode()) {
            try (ByteArrayOutputStream output = QrCodeGenWrapper.asGif(qrCodeOptions);){
                FileOutputStream out = new FileOutputStream(file);
                out.write(output.toByteArray());
                out.flush();
                out.close();
            }
            return true;
        }
        BufferedImage bufferedImage = QrCodeGenWrapper.asBufferedImage(qrCodeOptions);
        if (!ImageIO.write((RenderedImage)bufferedImage, qrCodeOptions.getPicType(), file)) {
            throw new IOException("save QrCode image to: " + absFileName + " error!");
        }
        return true;
    }

    public static class Builder {
        private static Logger log = LoggerFactory.getLogger(Builder.class);
        private static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();
        private String msg;
        private Integer w;
        private Integer h;
        private String code = "utf-8";
        private Integer padding;
        private ErrorCorrectionLevel errorCorrection = ErrorCorrectionLevel.H;
        private String picType = "png";
        private QrCodeOptions.BgImgOptions.BgImgOptionsBuilder bgImgOptions = QrCodeOptions.BgImgOptions.builder().bgImgStyle(QrCodeOptions.BgImgStyle.OVERRIDE).opacity(0.85f);
        private QrCodeOptions.LogoOptions.LogoOptionsBuilder logoOptions = QrCodeOptions.LogoOptions.builder().logoStyle(QrCodeOptions.LogoStyle.NORMAL).border(false).rate(12);
        private QrCodeOptions.DrawOptions.DrawOptionsBuilder drawOptions = QrCodeOptions.DrawOptions.builder().drawStyle(QrCodeOptions.DrawStyle.RECT).bgColor(Color.WHITE).preColor(Color.BLACK).diaphaneityFill(false).enableScale(false);
        private QrCodeOptions.DetectOptions.DetectOptionsBuilder detectOptions = QrCodeOptions.DetectOptions.builder();

        public String getMsg() {
            return this.msg;
        }

        public Builder setMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public Integer getW() {
            return this.w == null ? (this.h == null ? 200 : this.h) : this.w;
        }

        public Builder setW(Integer w) {
            if (w != null && w <= 0) {
                throw new IllegalArgumentException("\u751f\u6210\u4e8c\u7ef4\u7801\u7684\u5bbd\u5fc5\u987b\u5927\u4e8e0");
            }
            this.w = w;
            return this;
        }

        public Integer getH() {
            return this.h == null ? (this.w == null ? 200 : this.w) : this.h;
        }

        public Builder setH(Integer h) {
            if (h != null && h <= 0) {
                throw new IllegalArgumentException("\u751f\u6210\u529f\u80fd\u4e8c\u7ef4\u7801\u7684\u641e\u5fc5\u987b\u5927\u4e8e0");
            }
            this.h = h;
            return this;
        }

        public Builder setCode(String code) {
            this.code = code;
            return this;
        }

        public Integer getPadding() {
            if (this.padding == null) {
                return 1;
            }
            if (this.padding < 0) {
                return 0;
            }
            if (this.padding > 4) {
                return 4;
            }
            return this.padding;
        }

        public Builder setPadding(Integer padding) {
            this.padding = padding;
            return this;
        }

        public Builder setPicType(String picType) {
            this.picType = picType;
            return this;
        }

        public Builder setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
            this.errorCorrection = errorCorrection;
            return this;
        }

        public Builder setQrStyle(QrCodeOptions.ImgStyle qrStyle) {
            this.drawOptions.qrStyle(qrStyle);
            return this;
        }

        public Builder setQrCornerRadiusRate(float radius) {
            this.drawOptions.cornerRadius(Float.valueOf(radius));
            return this;
        }

        public Builder setLogo(String logo) throws IOException {
            try {
                return this.setLogo(ImageLoadUtil.getImageByPath((String)logo));
            }
            catch (IOException e) {
                log.error("load logo error!", (Throwable)e);
                throw new IOException("load logo error!", e);
            }
        }

        public Builder setLogo(InputStream inputStream) throws IOException {
            try {
                return this.setLogo(ImageIO.read(inputStream));
            }
            catch (IOException e) {
                log.error("load backgroundImg error!", (Throwable)e);
                throw new IOException("load backgroundImg error!", e);
            }
        }

        public Builder setLogo(BufferedImage img) {
            this.logoOptions.logo(img);
            return this;
        }

        public Builder setLogoStyle(QrCodeOptions.LogoStyle logoStyle) {
            this.logoOptions.logoStyle(logoStyle);
            return this;
        }

        public Builder setLogoBgColor(Integer color) {
            if (color == null) {
                return this;
            }
            return this.setLogoBgColor(ColorUtil.int2color((int)color));
        }

        public Builder setLogoBgColor(Color color) {
            this.logoOptions.border(true);
            this.logoOptions.borderColor(color);
            return this;
        }

        public Builder setLogoBorderBgColor(Integer color) {
            if (color == null) {
                return this;
            }
            return this.setLogoBorderBgColor(ColorUtil.int2color((int)color));
        }

        public Builder setLogoBorderBgColor(Color color) {
            this.logoOptions.border(true);
            this.logoOptions.outerBorderColor(color);
            return this;
        }

        public Builder setLogoBorder(boolean border) {
            this.logoOptions.border(border);
            return this;
        }

        public Builder setLogoRate(int rate) {
            this.logoOptions.rate(rate);
            return this;
        }

        public Builder setLogoOpacity(float opacity) {
            this.logoOptions.opacity(Float.valueOf(opacity));
            return this;
        }

        public Builder setBgImg(String bgImg) throws IOException {
            try {
                return this.setBgImg(FileReadUtil.getStreamByFileName((String)bgImg));
            }
            catch (IOException e) {
                log.error("load backgroundImg error!", (Throwable)e);
                throw new IOException("load backgroundImg error!", e);
            }
        }

        public Builder setBgImg(InputStream inputStream) throws IOException {
            try {
                ByteArrayInputStream target = IoUtil.toByteArrayInputStream((InputStream)inputStream);
                MediaType media = MediaType.typeOfMagicNum((String)FileReadUtil.getMagicNum((ByteArrayInputStream)target));
                if (media == MediaType.ImageGif) {
                    GifDecoder gifDecoder = new GifDecoder();
                    gifDecoder.read((InputStream)target);
                    this.bgImgOptions.gifDecoder(gifDecoder);
                    return this;
                }
                return this.setBgImg(ImageIO.read(target));
            }
            catch (IOException e) {
                log.error("load backgroundImg error!", (Throwable)e);
                throw new IOException("load backgroundImg error!", e);
            }
        }

        public Builder setBgImg(BufferedImage bufferedImage) {
            this.bgImgOptions.bgImg(bufferedImage);
            return this;
        }

        public Builder setBgImgStyle(QrCodeOptions.ImgStyle imgStyle) {
            this.bgImgOptions.imgStyle(imgStyle);
            return this;
        }

        public Builder setBgCornerRadiusRate(float radius) {
            this.bgImgOptions.cornerRadius(radius);
            return this;
        }

        public Builder setBgStyle(QrCodeOptions.BgImgStyle bgImgStyle) {
            this.bgImgOptions.bgImgStyle(bgImgStyle);
            return this;
        }

        public Builder setBgW(int w) {
            this.bgImgOptions.bgW(w);
            return this;
        }

        public Builder setBgH(int h) {
            this.bgImgOptions.bgH(h);
            return this;
        }

        public Builder setBgOpacity(float opacity) {
            this.bgImgOptions.opacity(opacity);
            return this;
        }

        public Builder setBgStartX(int startX) {
            this.bgImgOptions.startX(startX);
            return this;
        }

        public Builder setBgStartY(int startY) {
            this.bgImgOptions.startY(startY);
            return this;
        }

        public Builder setDetectImg(String detectImg) throws IOException {
            try {
                return this.setDetectImg(ImageLoadUtil.getImageByPath((String)detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setDetectImg(InputStream detectImg) throws IOException {
            try {
                return this.setDetectImg(ImageIO.read(detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setDetectImg(BufferedImage detectImg) {
            this.detectOptions.detectImg(detectImg);
            this.detectOptions.special(true);
            return this;
        }

        public Builder setLTDetectImg(String detectImg) throws IOException {
            try {
                return this.setLTDetectImg(ImageLoadUtil.getImageByPath((String)detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setLTDetectImg(InputStream detectImg) throws IOException {
            try {
                return this.setLTDetectImg(ImageIO.read(detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setLTDetectImg(BufferedImage detectImg) {
            this.detectOptions.detectImgLT(detectImg);
            this.detectOptions.special(true);
            return this;
        }

        public Builder setRTDetectImg(String detectImg) throws IOException {
            try {
                return this.setRTDetectImg(ImageLoadUtil.getImageByPath((String)detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setRTDetectImg(InputStream detectImg) throws IOException {
            try {
                return this.setRTDetectImg(ImageIO.read(detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setRTDetectImg(BufferedImage detectImg) {
            this.detectOptions.detectImgRT(detectImg);
            this.detectOptions.special(true);
            return this;
        }

        public Builder setLDDetectImg(String detectImg) throws IOException {
            try {
                return this.setLDDetectImg(ImageLoadUtil.getImageByPath((String)detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setLDDetectImg(InputStream detectImg) throws IOException {
            try {
                return this.setLDDetectImg(ImageIO.read(detectImg));
            }
            catch (IOException e) {
                log.error("load detectImage error! e:{}", (Throwable)e);
                throw new IOException("load detectImage error!", e);
            }
        }

        public Builder setLDDetectImg(BufferedImage detectImg) {
            this.detectOptions.detectImgLD(detectImg);
            this.detectOptions.special(true);
            return this;
        }

        public Builder setDetectOutColor(Integer outColor) {
            if (outColor == null) {
                return this;
            }
            return this.setDetectOutColor(ColorUtil.int2color((int)outColor));
        }

        public Builder setDetectOutColor(Color outColor) {
            this.detectOptions.outColor(outColor);
            return this;
        }

        public Builder setDetectInColor(Integer inColor) {
            if (inColor == null) {
                return this;
            }
            return this.setDetectInColor(ColorUtil.int2color((int)inColor));
        }

        public Builder setDetectInColor(Color inColor) {
            this.detectOptions.inColor(inColor);
            return this;
        }

        public Builder setDetectSpecial() {
            this.detectOptions.special(true);
            return this;
        }

        public Builder setDrawStyle(String style) {
            return this.setDrawStyle(QrCodeOptions.DrawStyle.getDrawStyle(style));
        }

        public Builder setDrawStyle(QrCodeOptions.DrawStyle drawStyle) {
            this.drawOptions.drawStyle(drawStyle);
            return this;
        }

        public Builder setDiaphaneityFill(boolean fill) {
            this.drawOptions.diaphaneityFill(fill);
            return this;
        }

        public Builder setDrawPreColor(int color) {
            return this.setDrawPreColor(ColorUtil.int2color((int)color));
        }

        public Builder setDrawPreColor(Color color) {
            this.drawOptions.preColor(color);
            return this;
        }

        public Builder setDrawBgColor(int color) {
            return this.setDrawBgColor(ColorUtil.int2color((int)color));
        }

        public Builder setDrawBgColor(Color color) {
            this.drawOptions.bgColor(color);
            return this;
        }

        public Builder setDrawBgImg(String img) throws IOException {
            try {
                return this.setDrawBgImg(ImageLoadUtil.getImageByPath((String)img));
            }
            catch (IOException e) {
                log.error("load drawBgImg error! e:{}", (Throwable)e);
                throw new IOException("load drawBgImg error!", e);
            }
        }

        public Builder setDrawBgImg(InputStream img) throws IOException {
            try {
                return this.setDrawBgImg(ImageIO.read(img));
            }
            catch (IOException e) {
                log.error("load drawBgImg error! e:{}", (Throwable)e);
                throw new IOException("load drawBgImg error!", e);
            }
        }

        public Builder setDrawBgImg(BufferedImage img) {
            this.drawOptions.bgImg(img);
            return this;
        }

        public Builder setDrawEnableScale(boolean enable) {
            this.drawOptions.enableScale(enable);
            return this;
        }

        public Builder setDrawImg(String img) throws IOException {
            try {
                return this.setDrawImg(ImageLoadUtil.getImageByPath((String)img));
            }
            catch (IOException e) {
                log.error("load draw img error! e: {}", (Throwable)e);
                throw new IOException("load draw img error!", e);
            }
        }

        public Builder setDrawImg(InputStream input) throws IOException {
            try {
                return this.setDrawImg(ImageIO.read(input));
            }
            catch (IOException e) {
                log.error("load draw img error! e: {}", (Throwable)e);
                throw new IOException("load draw img error!", e);
            }
        }

        public Builder setDrawImg(BufferedImage img) {
            this.addImg(1, 1, img);
            return this;
        }

        public Builder addImg(int row, int col, BufferedImage img) {
            if (img == null) {
                return this;
            }
            this.drawOptions.enableScale(true);
            this.drawOptions.drawImg(row, col, img);
            return this;
        }

        public Builder addImg(int row, int col, String img) throws IOException {
            try {
                return this.addImg(row, col, ImageLoadUtil.getImageByPath((String)img));
            }
            catch (IOException e) {
                log.error("load draw size4img error! e: {}", (Throwable)e);
                throw new IOException("load draw row:" + row + ", col:" + col + " img error!", e);
            }
        }

        public Builder addImg(int row, int col, InputStream img) throws IOException {
            try {
                return this.addImg(row, col, ImageIO.read(img));
            }
            catch (IOException e) {
                log.error("load draw size4img error! e: {}", (Throwable)e);
                throw new IOException("load draw row:" + row + ", col:" + col + " img error!", e);
            }
        }

        public Builder setQrText(String text) {
            this.drawOptions.text(text);
            return this;
        }

        public Builder setQrTxtMode(QrCodeOptions.TxtMode txtMode) {
            this.drawOptions.txtMode(txtMode);
            return this;
        }

        public Builder setQrDotFontName(String fontName) {
            this.drawOptions.fontName(fontName);
            return this;
        }

        public Builder setQrDotFontStyle(int fontStyle) {
            this.drawOptions.fontStyle(fontStyle);
            return this;
        }

        private void validate() {
            if (this.msg == null || this.msg.length() == 0) {
                throw new IllegalArgumentException("\u751f\u6210\u4e8c\u7ef4\u7801\u7684\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }

        private QrCodeOptions build() {
            this.validate();
            QrCodeOptions qrCodeConfig = new QrCodeOptions();
            qrCodeConfig.setMsg(this.getMsg());
            qrCodeConfig.setH(this.getH());
            qrCodeConfig.setW(this.getW());
            QrCodeOptions.BgImgOptions bgOp = this.bgImgOptions.build();
            if (bgOp.getBgImg() == null && bgOp.getGifDecoder() == null) {
                qrCodeConfig.setBgImgOptions(null);
            } else {
                qrCodeConfig.setBgImgOptions(bgOp);
            }
            QrCodeOptions.LogoOptions logoOp = this.logoOptions.build();
            if (logoOp.getLogo() == null) {
                qrCodeConfig.setLogoOptions(null);
            } else {
                qrCodeConfig.setLogoOptions(logoOp);
            }
            QrCodeOptions.DrawOptions drawOp = this.drawOptions.build();
            qrCodeConfig.setDrawOptions(drawOp);
            QrCodeOptions.DetectOptions detectOp = this.detectOptions.build();
            if (detectOp.getOutColor() == null && detectOp.getInColor() == null) {
                detectOp.setInColor(drawOp.getPreColor());
                detectOp.setOutColor(drawOp.getPreColor());
            } else if (detectOp.getOutColor() == null) {
                detectOp.setOutColor(detectOp.getOutColor());
            } else if (detectOp.getInColor() == null) {
                detectOp.setInColor(detectOp.getInColor());
            }
            qrCodeConfig.setDetectOptions(detectOp);
            if (qrCodeConfig.getBgImgOptions() != null && qrCodeConfig.getBgImgOptions().getBgImgStyle() == QrCodeOptions.BgImgStyle.PENETRATE) {
                drawOp.setPreColor(ColorUtil.OPACITY);
                qrCodeConfig.getBgImgOptions().setOpacity(1.0f);
                qrCodeConfig.getDetectOptions().setInColor(ColorUtil.OPACITY);
                qrCodeConfig.getDetectOptions().setOutColor(ColorUtil.OPACITY);
            }
            qrCodeConfig.setPicType(this.picType);
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3);
            hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrection);
            hints.put(EncodeHintType.CHARACTER_SET, this.code);
            hints.put(EncodeHintType.MARGIN, this.getPadding());
            qrCodeConfig.setHints(hints);
            return qrCodeConfig;
        }

        public String asString() throws IOException, WriterException {
            return QrCodeGenWrapper.asString(this.build());
        }

        public BufferedImage asBufferedImage() throws IOException, WriterException {
            return QrCodeGenWrapper.asBufferedImage(this.build());
        }

        public ByteArrayOutputStream asStream() throws WriterException, IOException {
            QrCodeOptions options = this.build();
            if (options.gifQrCode()) {
                return QrCodeGenWrapper.asGif(options);
            }
            BufferedImage img = QrCodeGenWrapper.asBufferedImage(options);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, options.getPicType(), outputStream);
            return outputStream;
        }

        public boolean asFile(String absFileName) throws IOException, WriterException {
            return QrCodeGenWrapper.asFile(this.build(), absFileName);
        }

        public String toString() {
            return "Builder{msg='" + this.msg + '\'' + ", w=" + this.w + ", h=" + this.h + ", code='" + this.code + '\'' + ", padding=" + this.padding + ", errorCorrection=" + this.errorCorrection + ", picType='" + this.picType + '\'' + ", bgImgOptions=" + this.bgImgOptions + ", logoOptions=" + this.logoOptions + ", drawOptions=" + this.drawOptions + ", detectOptions=" + this.detectOptions + '}';
        }
    }
}

