/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.qrcode.helper;

import com.github.hui.quick.plugin.base.GraphicUtil;
import com.github.hui.quick.plugin.base.ImageOperateUtil;
import com.github.hui.quick.plugin.qrcode.constants.QuickQrUtil;
import com.github.hui.quick.plugin.qrcode.entity.DotSize;
import com.github.hui.quick.plugin.qrcode.wrapper.BitMatrixEx;
import com.github.hui.quick.plugin.qrcode.wrapper.QrCodeOptions;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class QrCodeRenderHelper {
    public static BufferedImage drawLogo(BufferedImage qrImg, QrCodeOptions.LogoOptions logoOptions) {
        int logoHeight;
        int logoWidth;
        int qrWidth = qrImg.getWidth();
        int qrHeight = qrImg.getHeight();
        BufferedImage logoImg = logoOptions.getLogo();
        int radius = 0;
        if (logoOptions.getLogoStyle() == QrCodeOptions.LogoStyle.ROUND) {
            radius = logoImg.getWidth() >> 2;
            logoImg = ImageOperateUtil.makeRoundedCorner((BufferedImage)logoImg, (int)radius);
        } else if (logoOptions.getLogoStyle() == QrCodeOptions.LogoStyle.CIRCLE) {
            radius = Math.min(logoImg.getWidth(), logoImg.getHeight());
            logoImg = ImageOperateUtil.makeRoundImg((BufferedImage)logoImg, (boolean)false, null);
        }
        if (logoOptions.isBorder()) {
            if (logoOptions.getOuterBorderColor() != null) {
                logoImg = ImageOperateUtil.makeRoundBorder((BufferedImage)logoImg, (int)radius, (Color)logoOptions.getOuterBorderColor());
            }
            logoImg = ImageOperateUtil.makeRoundBorder((BufferedImage)logoImg, (int)radius, (Color)logoOptions.getBorderColor());
        }
        int logoRate = logoOptions.getRate();
        int calculateQrLogoWidth = (qrWidth << 1) / logoRate;
        int calculateQrLogoHeight = (qrHeight << 1) / logoRate;
        if (calculateQrLogoWidth < logoImg.getWidth()) {
            logoWidth = calculateQrLogoWidth;
            logoHeight = logoWidth * logoImg.getHeight() / logoImg.getWidth();
        } else if (calculateQrLogoHeight < logoImg.getHeight()) {
            logoHeight = calculateQrLogoHeight;
            logoWidth = logoHeight * logoImg.getWidth() / logoImg.getHeight();
        } else {
            logoWidth = logoImg.getWidth();
            logoHeight = logoImg.getHeight();
        }
        int logoOffsetX = qrWidth - logoWidth >> 1;
        int logoOffsetY = qrHeight - logoHeight >> 1;
        Graphics2D qrImgGraphic = GraphicUtil.getG2d((BufferedImage)qrImg);
        if (logoOptions.getOpacity() != null) {
            qrImgGraphic.setComposite(AlphaComposite.getInstance(10, logoOptions.getOpacity().floatValue()));
        }
        qrImgGraphic.drawImage(logoImg.getScaledInstance(logoWidth, logoHeight, 4), logoOffsetX, logoOffsetY, null);
        qrImgGraphic.dispose();
        logoImg.flush();
        return qrImg;
    }

    public static BufferedImage drawBackground(BufferedImage qrImg, QrCodeOptions.BgImgOptions bgImgOptions) {
        int qrWidth = qrImg.getWidth();
        int qrHeight = qrImg.getHeight();
        int bgW = Math.max(bgImgOptions.getBgW(), qrWidth);
        int bgH = Math.max(bgImgOptions.getBgH(), qrHeight);
        BufferedImage bgImg = bgImgOptions.getBgImg();
        if (bgImg.getWidth() != bgW || bgImg.getHeight() != bgH) {
            BufferedImage temp = new BufferedImage(bgW, bgH, 2);
            temp.getGraphics().drawImage(bgImg.getScaledInstance(bgW, bgH, 4), 0, 0, null);
            bgImg = temp;
        }
        if (bgImgOptions.getImgStyle() == QrCodeOptions.ImgStyle.ROUND) {
            int cornerRadius = (int)((float)Math.min(bgW, bgH) * bgImgOptions.getRadius());
            bgImg = ImageOperateUtil.makeRoundedCorner((BufferedImage)bgImg, (int)cornerRadius);
        } else if (bgImgOptions.getImgStyle() == QrCodeOptions.ImgStyle.CIRCLE) {
            bgImg = ImageOperateUtil.makeRoundImg((BufferedImage)bgImg, (boolean)false, null);
        }
        Graphics2D bgImgGraphic = GraphicUtil.getG2d((BufferedImage)bgImg);
        if (bgImgOptions.getBgImgStyle() == QrCodeOptions.BgImgStyle.FILL) {
            bgImgGraphic.setComposite(AlphaComposite.getInstance(10, 1.0f));
            bgImgGraphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            bgImgGraphic.drawImage(qrImg.getScaledInstance(qrWidth, qrHeight, 4), bgImgOptions.getStartX(), bgImgOptions.getStartY(), null);
        } else {
            int bgOffsetX = bgW - qrWidth >> 1;
            int bgOffsetY = bgH - qrHeight >> 1;
            bgImgGraphic.setComposite(AlphaComposite.getInstance(10, bgImgOptions.getOpacity()));
            bgImgGraphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            bgImgGraphic.drawImage(qrImg.getScaledInstance(qrWidth, qrHeight, 4), bgOffsetX, bgOffsetY, null);
            bgImgGraphic.setComposite(AlphaComposite.getInstance(10, 1.0f));
        }
        bgImgGraphic.dispose();
        bgImg.flush();
        return bgImg;
    }

    public static List<ImmutablePair<BufferedImage, Integer>> drawGifBackground(BufferedImage qrImg, QrCodeOptions.BgImgOptions bgImgOptions) {
        int qrWidth = qrImg.getWidth();
        int qrHeight = qrImg.getHeight();
        int bgW = Math.max(bgImgOptions.getBgW(), qrWidth);
        int bgH = Math.max(bgImgOptions.getBgH(), qrHeight);
        boolean fillMode = bgImgOptions.getBgImgStyle() == QrCodeOptions.BgImgStyle.FILL;
        int bgOffsetX = fillMode ? bgImgOptions.getStartX() : bgW - qrWidth >> 1;
        int bgOffsetY = fillMode ? bgImgOptions.getStartY() : bgH - qrHeight >> 1;
        int gifImgLen = bgImgOptions.getGifDecoder().getFrameCount();
        ArrayList<ImmutablePair<BufferedImage, Integer>> result = new ArrayList<ImmutablePair<BufferedImage, Integer>>(gifImgLen);
        int len = bgImgOptions.getGifDecoder().getFrameCount();
        for (int index = 0; index < len; ++index) {
            BufferedImage bgImg = bgImgOptions.getGifDecoder().getFrame(index);
            BufferedImage temp = new BufferedImage(bgW, bgH, 1);
            temp.getGraphics().setColor(Color.WHITE);
            temp.getGraphics().fillRect(0, 0, bgW, bgH);
            temp.getGraphics().drawImage(bgImg.getScaledInstance(bgW, bgH, 4), 0, 0, null);
            bgImg = temp;
            Graphics2D bgGraphic = GraphicUtil.getG2d((BufferedImage)bgImg);
            if (bgImgOptions.getBgImgStyle() == QrCodeOptions.BgImgStyle.FILL) {
                bgGraphic.setComposite(AlphaComposite.getInstance(10, 1.0f));
                bgGraphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                bgGraphic.drawImage(qrImg.getScaledInstance(qrWidth, qrHeight, 4), bgOffsetX, bgOffsetY, null);
            } else {
                bgGraphic.setComposite(AlphaComposite.getInstance(10, bgImgOptions.getOpacity()));
                bgGraphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                bgGraphic.drawImage(qrImg.getScaledInstance(qrWidth, qrHeight, 4), bgOffsetX, bgOffsetY, null);
                bgGraphic.setComposite(AlphaComposite.getInstance(10, 1.0f));
            }
            bgGraphic.dispose();
            bgImg.flush();
            result.add((ImmutablePair<BufferedImage, Integer>)ImmutablePair.of((Object)bgImg, (Object)bgImgOptions.getGifDecoder().getDelay(index)));
        }
        return result;
    }

    public static BufferedImage drawQrInfo(QrCodeOptions qrCodeConfig, BitMatrixEx bitMatrix) {
        int qrWidth = bitMatrix.getWidth();
        int qrHeight = bitMatrix.getHeight();
        int infoSize = bitMatrix.getMultiple();
        BufferedImage qrImg = new BufferedImage(qrWidth, qrHeight, 2);
        QrCodeOptions.DrawOptions drawOptions = qrCodeConfig.getDrawOptions();
        Color bgColor = drawOptions.getBgColor();
        Color preColor = drawOptions.getPreColor();
        Color detectOutColor = qrCodeConfig.getDetectOptions().getOutColor();
        Color detectInnerColor = qrCodeConfig.getDetectOptions().getInColor();
        if (detectInnerColor != null || detectOutColor != null) {
            if (detectInnerColor == null) {
                detectInnerColor = detectOutColor;
            } else if (detectOutColor == null) {
                detectOutColor = detectInnerColor;
            }
        }
        int leftPadding = bitMatrix.getLeftPadding();
        int topPadding = bitMatrix.getTopPadding();
        Graphics2D g2 = GraphicUtil.getG2d((BufferedImage)qrImg);
        if (!drawOptions.isDiaphaneityFill()) {
            g2.setComposite(AlphaComposite.Src);
        }
        g2.setColor(bgColor);
        g2.fillRect(0, 0, qrWidth, qrHeight);
        if (drawOptions.getDrawStyle() == QrCodeOptions.DrawStyle.TXT) {
            g2.setFont(QuickQrUtil.font(drawOptions.getFontName(), drawOptions.getFontStyle(), infoSize));
        }
        int detectCornerSize = bitMatrix.getByteMatrix().get(0, 5) == 1 ? 7 : 5;
        int matrixW = bitMatrix.getByteMatrix().getWidth();
        int matrixH = bitMatrix.getByteMatrix().getHeight();
        QrCodeOptions.DrawStyle drawStyle = drawOptions.getDrawStyle();
        for (int x = 0; x < matrixW; ++x) {
            for (int y = 0; y < matrixH; ++y) {
                DetectLocation detectLocation = QrCodeRenderHelper.inDetectCornerArea(x, y, matrixW, matrixH, detectCornerSize);
                if (bitMatrix.getByteMatrix().get(x, y) == 0) {
                    if (detectLocation.detectedArea() && qrCodeConfig.getDetectOptions().getSpecial().booleanValue()) continue;
                    QrCodeRenderHelper.drawQrDotBgImg(qrCodeConfig, g2, leftPadding, topPadding, infoSize, x, y);
                    continue;
                }
                if (detectLocation.detectedArea() && qrCodeConfig.getDetectOptions().getSpecial().booleanValue()) {
                    QrCodeRenderHelper.drawDetectImg(qrCodeConfig, g2, bitMatrix, matrixW, matrixH, leftPadding, topPadding, infoSize, detectCornerSize, x, y, detectOutColor, detectInnerColor, detectLocation);
                    continue;
                }
                g2.setColor(preColor);
                QrCodeRenderHelper.drawQrDotImg(qrCodeConfig, drawStyle, g2, bitMatrix, leftPadding, topPadding, infoSize, x, y);
            }
        }
        g2.dispose();
        qrImg = QrCodeRenderHelper.scaleQr2RealSize(qrCodeConfig, bitMatrix, qrImg);
        if (drawOptions.getQrStyle() == QrCodeOptions.ImgStyle.CIRCLE) {
            return ImageOperateUtil.makeRoundImg((BufferedImage)qrImg, (boolean)false, null);
        }
        if (drawOptions.getQrStyle() == QrCodeOptions.ImgStyle.ROUND) {
            float radius = (float)Math.min(qrCodeConfig.getW(), qrCodeConfig.getH()) * drawOptions.getCornerRadius().floatValue();
            return ImageOperateUtil.makeRoundedCorner((BufferedImage)qrImg, (int)((int)radius));
        }
        return qrImg;
    }

    private static BufferedImage scaleQr2RealSize(QrCodeOptions qrCodeConfig, BitMatrixEx bitMatrix, BufferedImage qrCode) {
        int qrCodeWidth = bitMatrix.getWidth();
        int qrCodeHeight = bitMatrix.getHeight();
        int realQrCodeWidth = qrCodeConfig.getW();
        int realQrCodeHeight = qrCodeConfig.getH();
        if (qrCodeWidth != realQrCodeWidth || qrCodeHeight != realQrCodeHeight) {
            qrCode = GraphicUtil.createImg((int)realQrCodeWidth, (int)realQrCodeHeight, (int)0, (int)0, (BufferedImage)qrCode);
        }
        return qrCode;
    }

    private static DetectLocation inDetectCornerArea(int x, int y, int matrixW, int matrixH, int detectCornerSize) {
        if (x < detectCornerSize && y < detectCornerSize) {
            return DetectLocation.LT;
        }
        if (x < detectCornerSize && y >= matrixH - detectCornerSize) {
            return DetectLocation.LD;
        }
        if (x >= matrixW - detectCornerSize && y < detectCornerSize) {
            return DetectLocation.RT;
        }
        return DetectLocation.NONE;
    }

    private static boolean inOuterDetectCornerArea(int x, int y, int matrixW, int matrixH, int detectCornerSize) {
        return x == 0 || x == detectCornerSize - 1 || x == matrixW - 1 || x == matrixW - detectCornerSize || y == 0 || y == detectCornerSize - 1 || y == matrixH - 1 || y == matrixH - detectCornerSize;
    }

    private static void drawDetectImg(QrCodeOptions qrCodeConfig, Graphics2D g2, BitMatrixEx bitMatrix, int matrixW, int matrixH, int leftPadding, int topPadding, int infoSize, int detectCornerSize, int x, int y, Color detectOutColor, Color detectInnerColor, DetectLocation detectLocation) {
        BufferedImage detectedImg = qrCodeConfig.getDetectOptions().chooseDetectedImg(detectLocation);
        if (detectedImg != null) {
            g2.drawImage(detectedImg.getScaledInstance(infoSize * detectCornerSize, infoSize * detectCornerSize, 4), leftPadding + x * infoSize, topPadding + y * infoSize, null);
            for (int addX = 0; addX < detectCornerSize; ++addX) {
                for (int addY = 0; addY < detectCornerSize; ++addY) {
                    bitMatrix.getByteMatrix().set(x + addX, y + addY, 0);
                }
            }
            return;
        }
        if (QrCodeRenderHelper.inOuterDetectCornerArea(x, y, matrixW, matrixH, detectCornerSize)) {
            g2.setColor(detectOutColor);
        } else {
            g2.setColor(detectInnerColor);
        }
        g2.fillRect(leftPadding + x * infoSize, topPadding + y * infoSize, infoSize, infoSize);
    }

    private static void drawQrDotBgImg(QrCodeOptions qrCodeConfig, Graphics2D g2, int leftPadding, int topPadding, int infoSize, int x, int y) {
        if (qrCodeConfig.getDrawOptions().getBgImg() == null) {
            return;
        }
        QrCodeOptions.DrawStyle.IMAGE.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, infoSize, infoSize, qrCodeConfig.getDrawOptions().getBgImg(), null);
    }

    private static void drawQrDotImg(QrCodeOptions qrCodeConfig, QrCodeOptions.DrawStyle drawStyle, Graphics2D g2, BitMatrixEx bitMatrix, int leftPadding, int topPadding, int infoSize, int x, int y) {
        if (drawStyle != QrCodeOptions.DrawStyle.IMAGE) {
            QrCodeRenderHelper.drawGeometricFigure(qrCodeConfig, drawStyle, g2, bitMatrix, leftPadding, topPadding, infoSize, x, y);
        } else {
            QrCodeRenderHelper.drawSpecialImg(qrCodeConfig, drawStyle, g2, bitMatrix, leftPadding, topPadding, infoSize, x, y);
        }
    }

    private static void drawGeometricFigure(QrCodeOptions qrCodeConfig, QrCodeOptions.DrawStyle drawStyle, Graphics2D g2, BitMatrixEx bitMatrix, int leftPadding, int topPadding, int infoSize, int x, int y) {
        if (!qrCodeConfig.getDrawOptions().isEnableScale()) {
            drawStyle.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, infoSize, infoSize, qrCodeConfig.getDrawOptions().getImage(1, 1), qrCodeConfig.getDrawOptions().getDrawQrTxt());
            return;
        }
        int maxRow = QrCodeRenderHelper.getMaxRow(bitMatrix.getByteMatrix(), x, y);
        int maxCol = QrCodeRenderHelper.getMaxCol(bitMatrix.getByteMatrix(), x, y);
        List<DotSize> availableSize = QrCodeRenderHelper.getAvailableSize(bitMatrix.getByteMatrix(), x, y, maxRow, maxCol);
        for (DotSize dotSize : availableSize) {
            if (!drawStyle.expand(dotSize)) continue;
            drawStyle.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, dotSize.getCol() * infoSize, dotSize.getRow() * infoSize, qrCodeConfig.getDrawOptions().getImage(dotSize), qrCodeConfig.getDrawOptions().getDrawQrTxt());
            for (int col = 0; col < dotSize.getCol(); ++col) {
                for (int row = 0; row < dotSize.getRow(); ++row) {
                    bitMatrix.getByteMatrix().set(x + col, y + row, 0);
                }
            }
            return;
        }
        drawStyle.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, infoSize, infoSize, qrCodeConfig.getDrawOptions().getImage(1, 1), qrCodeConfig.getDrawOptions().getDrawQrTxt());
    }

    private static void drawSpecialImg(QrCodeOptions qrCodeConfig, QrCodeOptions.DrawStyle drawStyle, Graphics2D g2, BitMatrixEx bitMatrix, int leftPadding, int topPadding, int infoSize, int x, int y) {
        int maxRow = QrCodeRenderHelper.getMaxRow(bitMatrix.getByteMatrix(), x, y);
        int maxCol = QrCodeRenderHelper.getMaxCol(bitMatrix.getByteMatrix(), x, y);
        List<DotSize> availableSize = QrCodeRenderHelper.getAvailableSize(bitMatrix.getByteMatrix(), x, y, maxRow, maxCol);
        for (DotSize dotSize : availableSize) {
            BufferedImage drawImg = qrCodeConfig.getDrawOptions().getImage(dotSize);
            if (drawImg == null) continue;
            drawStyle.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, dotSize.getCol() * infoSize, dotSize.getRow() * infoSize, drawImg, qrCodeConfig.getDrawOptions().getDrawQrTxt());
            for (int col = 0; col < dotSize.getCol(); ++col) {
                for (int row = 0; row < dotSize.getRow(); ++row) {
                    bitMatrix.getByteMatrix().set(x + col, y + row, 0);
                }
            }
            return;
        }
        drawStyle.draw(g2, leftPadding + x * infoSize, topPadding + y * infoSize, infoSize, infoSize, qrCodeConfig.getDrawOptions().getImage(DotSize.SIZE_1_1), qrCodeConfig.getDrawOptions().getDrawQrTxt());
    }

    private static int getMaxRow(ByteMatrix bitMatrix, int x, int y) {
        int cnt = 1;
        while (++y < bitMatrix.getHeight() && bitMatrix.get(x, y) != 0) {
            ++cnt;
        }
        return cnt;
    }

    private static int getMaxCol(ByteMatrix bitMatrix, int x, int y) {
        int cnt = 1;
        while (++x < bitMatrix.getWidth() && bitMatrix.get(x, y) != 0) {
            ++cnt;
        }
        return cnt;
    }

    private static List<DotSize> getAvailableSize(ByteMatrix bitMatrix, int x, int y, int maxRow, int maxCol) {
        if (maxRow == 1) {
            return Collections.singletonList(DotSize.create(1, maxCol));
        }
        if (maxCol == 1) {
            return Collections.singletonList(DotSize.create(maxRow, 1));
        }
        ArrayList<DotSize> container = new ArrayList<DotSize>();
        int col = 1;
        int lastRow = maxRow;
        while (col < maxCol) {
            int offset = 0;
            int row = 1;
            while (++offset < lastRow && bitMatrix.get(x + col, y + offset) != 0) {
                ++row;
            }
            lastRow = row;
            container.add(new DotSize(row, ++col));
        }
        container.sort((o1, o2) -> o2.size() - o1.size());
        return container;
    }

    public static enum DetectLocation {
        LT,
        LD,
        RT,
        NONE{

            @Override
            public boolean detectedArea() {
                return false;
            }
        };


        public boolean detectedArea() {
            return true;
        }
    }
}

