/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.qrcode.helper;

import com.github.hui.quick.plugin.qrcode.helper.QrCodeRenderHelper;
import com.github.hui.quick.plugin.qrcode.wrapper.BitMatrixEx;
import com.github.hui.quick.plugin.qrcode.wrapper.QrCodeOptions;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeGenerateHelper {
    private static Logger log = LoggerFactory.getLogger(QrCodeGenerateHelper.class);
    private static final int QUIET_ZONE_SIZE = 4;

    public static BitMatrixEx encode(QrCodeOptions qrCodeConfig) throws WriterException {
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int quietZone = 1;
        if (qrCodeConfig.getHints() != null) {
            if (qrCodeConfig.getHints().containsKey(EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = ErrorCorrectionLevel.valueOf((String)qrCodeConfig.getHints().get(EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (qrCodeConfig.getHints().containsKey(EncodeHintType.MARGIN)) {
                quietZone = Integer.parseInt(qrCodeConfig.getHints().get(EncodeHintType.MARGIN).toString());
            }
            if (quietZone > 4) {
                quietZone = 4;
            } else if (quietZone < 0) {
                quietZone = 0;
            }
        }
        QRCode code = Encoder.encode((String)qrCodeConfig.getMsg(), (ErrorCorrectionLevel)errorCorrectionLevel, qrCodeConfig.getHints());
        return QrCodeGenerateHelper.renderResult(code, qrCodeConfig.getW(), qrCodeConfig.getH(), quietZone);
    }

    private static BitMatrixEx renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int minSize = Math.min(width, height);
        int scale = QrCodeGenerateHelper.calculateScale(qrWidth, minSize);
        if (scale > 0) {
            if (log.isDebugEnabled()) {
                log.debug("qrCode scale enable! scale: {}, qrSize:{}, expectSize:{}x{}", new Object[]{scale, qrWidth, width, height});
            }
            int padding = (minSize - qrWidth * scale) / 4 * quietZone;
            int tmpValue = qrWidth * scale + padding;
            if (width == height) {
                width = tmpValue;
                height = tmpValue;
            } else if (width > height) {
                width = width * tmpValue / height;
                height = tmpValue;
            } else {
                height = height * tmpValue / width;
                width = tmpValue;
            }
        }
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrixEx res = new BitMatrixEx();
        res.setByteMatrix(input);
        res.setLeftPadding(leftPadding);
        res.setTopPadding(topPadding);
        res.setMultiple(multiple);
        res.setWidth(outputWidth);
        res.setHeight(outputHeight);
        return res;
    }

    private static int calculateScale(int qrCodeSize, int expectSize) {
        if (qrCodeSize >= expectSize) {
            return 0;
        }
        int scale = expectSize / qrCodeSize;
        int abs = expectSize - scale * qrCodeSize;
        if ((double)abs < (double)expectSize * 0.15) {
            return 0;
        }
        return scale;
    }

    public static BufferedImage toBufferedImage(QrCodeOptions qrCodeConfig, BitMatrixEx bitMatrix) throws IOException {
        BufferedImage qrCode = QrCodeRenderHelper.drawQrInfo(qrCodeConfig, bitMatrix);
        boolean logoAlreadyDraw = false;
        if (qrCodeConfig.getBgImgOptions() != null) {
            if (qrCodeConfig.getBgImgOptions().getBgImgStyle() == QrCodeOptions.BgImgStyle.FILL && qrCodeConfig.getLogoOptions() != null) {
                qrCode = QrCodeRenderHelper.drawLogo(qrCode, qrCodeConfig.getLogoOptions());
                logoAlreadyDraw = true;
            }
            qrCode = QrCodeRenderHelper.drawBackground(qrCode, qrCodeConfig.getBgImgOptions());
        }
        if (qrCodeConfig.getLogoOptions() != null && !logoAlreadyDraw) {
            qrCode = QrCodeRenderHelper.drawLogo(qrCode, qrCodeConfig.getLogoOptions());
        }
        return qrCode;
    }

    public static List<ImmutablePair<BufferedImage, Integer>> toGifImages(QrCodeOptions qrCodeConfig, BitMatrixEx bitMatrix) {
        if (qrCodeConfig.getBgImgOptions() == null || qrCodeConfig.getBgImgOptions().getGifDecoder().getFrameCount() <= 0) {
            throw new IllegalArgumentException("animated background image should not be null!");
        }
        BufferedImage qrCode = QrCodeRenderHelper.drawQrInfo(qrCodeConfig, bitMatrix);
        boolean logoAlreadyDraw = false;
        if (qrCodeConfig.getBgImgOptions().getBgImgStyle() == QrCodeOptions.BgImgStyle.FILL && qrCodeConfig.getLogoOptions() != null) {
            qrCode = QrCodeRenderHelper.drawLogo(qrCode, qrCodeConfig.getLogoOptions());
            logoAlreadyDraw = true;
        }
        List<ImmutablePair<BufferedImage, Integer>> bgList = QrCodeRenderHelper.drawGifBackground(qrCode, qrCodeConfig.getBgImgOptions());
        if (qrCodeConfig.getLogoOptions() != null && !logoAlreadyDraw) {
            ArrayList<ImmutablePair<BufferedImage, Integer>> result = new ArrayList<ImmutablePair<BufferedImage, Integer>>(bgList.size());
            for (ImmutablePair<BufferedImage, Integer> pair : bgList) {
                result.add((ImmutablePair<BufferedImage, Integer>)ImmutablePair.of((Object)QrCodeRenderHelper.drawLogo((BufferedImage)pair.getLeft(), qrCodeConfig.getLogoOptions()), (Object)pair.getRight()));
            }
            return result;
        }
        return bgList;
    }
}

