/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base.gif;

import com.github.hui.quick.plugin.base.FileReadUtil;
import com.github.hui.quick.plugin.base.FileWriteUtil;
import com.github.hui.quick.plugin.base.gif.GifDecoder;
import com.github.hui.quick.plugin.base.gif.GifEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GifHelper {
    public static int loadGif(String gif, List<BufferedImage> list) throws IOException {
        return GifHelper.loadGif(FileReadUtil.getStreamByFileName(gif), list);
    }

    public static int loadGif(InputStream stream, List<BufferedImage> list) {
        GifDecoder decoder = new GifDecoder();
        decoder.read(stream);
        int delay = 100;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            if (delay > decoder.getDelay(i)) {
                delay = decoder.getDelay(i);
            }
            list.add(decoder.getFrame(i));
        }
        return delay;
    }

    public static void saveGif(List<BufferedImage> frames, int delay, String out) throws FileNotFoundException {
        FileWriteUtil.mkDir(new File(out).getParentFile());
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(out));
        GifHelper.saveGif(frames, delay, outputStream);
    }

    public static void saveGif(List<BufferedImage> frames, int delay, OutputStream out) {
        GifEncoder encoder = new GifEncoder();
        encoder.setRepeat(0);
        encoder.start(out);
        encoder.setDelay(delay);
        for (BufferedImage img : frames) {
            encoder.setDelay(delay);
            encoder.addFrame(img);
        }
        encoder.addFrame(frames.get(frames.size() - 1));
        encoder.finish();
    }

    public static void saveGif(List<ImmutablePair<BufferedImage, Integer>> frames, OutputStream out) {
        GifEncoder encoder = new GifEncoder();
        encoder.setRepeat(0);
        encoder.start(out);
        for (ImmutablePair<BufferedImage, Integer> frame : frames) {
            encoder.setDelay((Integer)frame.getRight());
            encoder.addFrame((BufferedImage)frame.getLeft());
        }
        encoder.finish();
    }
}

