/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static Logger log = LoggerFactory.getLogger(ProcessUtil.class);
    public static final int BUFFER_SIZE = 65536;
    public static final int EXEC_TIME_OUT = 2;
    private ExecutorService exec = new ThreadPoolExecutor(6, 12, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10), new CustomThreadFactory("cmd-process"), new ThreadPoolExecutor.CallerRunsPolicy());

    private ProcessUtil() {
    }

    public static ProcessUtil instance() {
        return InputStreamConsumer.instance;
    }

    public boolean process(String cmd) throws Exception {
        Process process = Runtime.getRuntime().exec(cmd);
        this.waitForProcess(process);
        return true;
    }

    private int waitForProcess(Process pProcess) throws IOException, InterruptedException, TimeoutException, ExecutionException {
        FutureTask<Object> outTask = new FutureTask<Object>(() -> {
            this.processOutput(pProcess.getInputStream(), InputStreamConsumer.DEFAULT_CONSUMER);
            return null;
        });
        this.exec.submit(outTask);
        FutureTask<Object> errTask = new FutureTask<Object>(() -> {
            this.processError(pProcess.getErrorStream(), InputStreamConsumer.DEFAULT_CONSUMER);
            return null;
        });
        this.exec.submit(errTask);
        try {
            outTask.get();
            errTask.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(e);
        }
        FutureTask<Integer> processTask = new FutureTask<Integer>(() -> {
            pProcess.waitFor();
            return pProcess.exitValue();
        });
        this.exec.submit(processTask);
        int rc = processTask.get(2L, TimeUnit.SECONDS);
        try {
            pProcess.getInputStream().close();
            pProcess.getOutputStream().close();
            pProcess.getErrorStream().close();
        }
        catch (Exception e) {
            log.error("close stream error! e: {}", (Throwable)e);
        }
        return rc;
    }

    private void processOutput(InputStream pInputStream, InputStreamConsumer pConsumer) throws IOException {
        pConsumer.consume(pInputStream);
    }

    private void processError(InputStream pInputStream, InputStreamConsumer pConsumer) throws IOException {
        pConsumer.consume(pInputStream);
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private String name;
        private AtomicInteger count = new AtomicInteger(0);

        public CustomThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.name + "-" + this.count.addAndGet(1));
        }
    }

    private static class InputStreamConsumer {
        static ProcessUtil instance = new ProcessUtil();
        static InputStreamConsumer DEFAULT_CONSUMER = new InputStreamConsumer();

        private InputStreamConsumer() {
        }

        void consume(InputStream stream) throws IOException {
            String temp;
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 65536);
            while ((temp = reader.readLine()) != null) {
                builder.append(temp);
            }
            if (log.isDebugEnabled()) {
                log.debug("cmd process input stream: {}", (Object)builder.toString());
            }
            reader.close();
        }
    }
}

