/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class ImageOperateUtil {
    public static BufferedImage makeRoundImg(BufferedImage image, boolean borderEnable, Color borderColor) {
        int x;
        int y;
        int size;
        if (image.getWidth() > image.getHeight()) {
            size = image.getHeight();
            y = 0;
            x = image.getWidth() - image.getHeight() >> 1;
        } else {
            size = image.getWidth();
            x = 0;
            y = image.getHeight() - image.getWidth() >> 1;
        }
        BufferedImage ans = ImageOperateUtil.makeRoundImg(image, new Rectangle(x, y, size, size), size);
        if (borderEnable) {
            ans = ImageOperateUtil.makeRoundBorder(ans, size, borderColor);
        }
        return ans;
    }

    public static BufferedImage makeRoundImg(BufferedImage image, Rectangle rectangle, int cornerRadius) {
        int x = (int)rectangle.getX();
        int y = (int)rectangle.getY();
        int w = (int)rectangle.getWidth();
        int h = (int)rectangle.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, -x, -y, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage makeRoundBorder(BufferedImage image, int cornerRadius, Color color) {
        int size = image.getWidth() / 15;
        int w = image.getWidth() + size;
        int h = image.getHeight() + size;
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(color == null ? Color.WHITE : color);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g2.drawImage((Image)image, size >> 1, size >> 1, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }
}

