/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static InputStream downFile(String src) throws IOException {
        return HttpUtil.downFile(URI.create(src));
    }

    public static InputStream downFile(URI uri) throws IOException {
        HttpResponse httpResponse;
        try {
            Request request = Request.Get((URI)uri);
            HttpHost httpHost = URIUtils.extractHost((URI)uri);
            if (StringUtils.isNotEmpty((CharSequence)httpHost.getHostName())) {
                request.setHeader("Host", httpHost.getHostName());
            }
            request.addHeader("user-agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36");
            httpResponse = request.execute().returnResponse();
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8bf7\u6c42\u5931\u8d25\uff0curl=" + uri, (Throwable)e);
            throw new FileNotFoundException();
        }
        int code = httpResponse.getStatusLine().getStatusCode();
        if (code != 200) {
            throw new FileNotFoundException();
        }
        return httpResponse.getEntity().getContent();
    }
}

