/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import com.github.hui.quick.plugin.base.BasicFileUtil;
import com.github.hui.quick.plugin.base.HttpUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriteUtil {
    private static final Logger log = LoggerFactory.getLogger(FileWriteUtil.class);
    public static String TEMP_PATH = "/tmp/quickmedia/";
    private static Random FILENAME_GEN_RANDOM = new Random();

    public static String getTmpPath() {
        String tmpPathEnvProperties = System.getProperty("quick.media.tmp.path");
        if (StringUtils.isNotBlank((CharSequence)tmpPathEnvProperties)) {
            TEMP_PATH = tmpPathEnvProperties.endsWith("/") ? tmpPathEnvProperties : tmpPathEnvProperties + "/";
        }
        return TEMP_PATH + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
    }

    public static <T> FileInfo saveFile(T src, String inputType) throws Exception {
        if (src instanceof String) {
            return FileWriteUtil.saveFileByPath((String)src);
        }
        if (src instanceof URI) {
            return FileWriteUtil.saveFileByURI((URI)src);
        }
        if (src instanceof InputStream) {
            return FileWriteUtil.saveFileByStream((InputStream)src, inputType);
        }
        throw new IllegalStateException("save file parameter only support String/URI/InputStream type! but input type is: " + (src == null ? null : src.getClass()));
    }

    private static FileInfo saveFileByPath(String path) throws Exception {
        if (path.startsWith("http")) {
            return FileWriteUtil.saveFileByURI(URI.create(path));
        }
        String tmpAbsFile = BasicFileUtil.isAbsFile(path) ? path : (path.startsWith("~") ? BasicFileUtil.parseHomeDir2AbsDir(path) : FileWriteUtil.class.getClassLoader().getResource(path).getFile());
        return FileWriteUtil.parseAbsFileToFileInfo(tmpAbsFile);
    }

    private static FileInfo saveFileByURI(URI uri) throws Exception {
        String path = uri.getPath();
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("a select uri should be choosed! but input path is: " + path);
        }
        int index = path.lastIndexOf("/");
        String filename = path.substring(index + 1);
        FileInfo fileInfo = new FileInfo();
        FileWriteUtil.extraFileName(filename, fileInfo);
        fileInfo.setPath(FileWriteUtil.getTmpPath());
        try {
            InputStream inputStream = HttpUtil.downFile(uri);
            return FileWriteUtil.saveFileByStream(inputStream, fileInfo);
        }
        catch (Exception e) {
            log.error("down file from url: {} error! e: {}", (Object)uri, (Object)e);
            throw e;
        }
    }

    public static FileInfo saveFileByStream(InputStream inputStream, String fileType) throws Exception {
        return FileWriteUtil.saveFileByStream(inputStream, FileWriteUtil.getTmpPath(), FileWriteUtil.genTempFileName(), fileType);
    }

    public static FileInfo saveFileByStream(InputStream stream, String path, String filename, String fileType) throws FileNotFoundException {
        return FileWriteUtil.saveFileByStream(stream, new FileInfo(path, filename, fileType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo saveFileByStream(InputStream stream, FileInfo fileInfo) throws FileNotFoundException {
        if (!StringUtils.isBlank((CharSequence)fileInfo.getPath())) {
            FileWriteUtil.mkDir(new File(fileInfo.getPath()));
        }
        String tempAbsFile = fileInfo.getPath() + "/" + fileInfo.getFilename() + "." + fileInfo.getFileType();
        BufferedOutputStream outputStream = null;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(stream);
            outputStream = new BufferedOutputStream(new FileOutputStream(tempAbsFile));
            int len = ((InputStream)inputStream).available();
            if (len <= 4096) {
                byte[] bytes = new byte[len];
                ((InputStream)inputStream).read(bytes);
                outputStream.write(bytes);
            } else {
                int byteCount = 0;
                byte[] bytes = new byte[4096];
                while ((byteCount = ((InputStream)inputStream).read(bytes)) != -1) {
                    outputStream.write(bytes, 0, byteCount);
                }
            }
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
        catch (Exception e) {
            log.error("save stream into file error! filename: {} e: {}", (Object)tempAbsFile, (Object)e);
            FileInfo fileInfo3 = null;
            return fileInfo3;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                log.error("close stream error! e: {}", (Throwable)e);
            }
        }
    }

    private static String genTempFileName() {
        return System.currentTimeMillis() + "_" + FILENAME_GEN_RANDOM.nextInt(1000);
    }

    public static void mkDir(File path) throws FileNotFoundException {
        if (path.getParentFile() == null) {
            path = path.getAbsoluteFile();
        }
        if (path.getParentFile().exists()) {
            FileWriteUtil.modifyFileAuth(path);
            if (!path.exists() && !path.mkdir()) {
                throw new FileNotFoundException();
            }
        } else {
            FileWriteUtil.mkDir(path.getParentFile());
            FileWriteUtil.modifyFileAuth(path);
            if (!path.exists() && !path.mkdir()) {
                throw new FileNotFoundException();
            }
        }
    }

    private static void modifyFileAuth(File file) {
        boolean ans = file.setExecutable(true, false);
        ans = file.setReadable(true, false) && ans;
        boolean bl = ans = file.setWritable(true, false) && ans;
        if (log.isDebugEnabled()) {
            log.debug("create file auth : {}", (Object)ans);
        }
    }

    public static FileInfo parseAbsFileToFileInfo(String absFile) {
        FileInfo fileInfo = new FileInfo();
        FileWriteUtil.extraFilePath(absFile, fileInfo);
        FileWriteUtil.extraFileName(fileInfo.getFilename(), fileInfo);
        return fileInfo;
    }

    private static void extraFilePath(String absFilename, FileInfo fileInfo) {
        int index = absFilename.lastIndexOf("/");
        if (index < 0) {
            fileInfo.setPath(FileWriteUtil.getTmpPath());
            fileInfo.setFilename(absFilename);
        } else {
            fileInfo.setPath(absFilename.substring(0, index));
            fileInfo.setFilename(index + 1 == absFilename.length() ? "" : absFilename.substring(index + 1));
        }
    }

    private static void extraFileName(String fileName, FileInfo fileInfo) {
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            fileInfo.setFilename(fileName);
            fileInfo.setFileType("");
        } else {
            fileInfo.setFilename(fileName.substring(0, index));
            fileInfo.setFileType(index + 1 == fileName.length() ? "" : fileName.substring(index + 1));
        }
    }

    public static class FileInfo {
        private String path;
        private String filename;
        private String fileType;

        public FileInfo() {
        }

        public FileInfo(String path, String filename, String fileType) {
            this.path = path;
            this.filename = filename;
            this.fileType = fileType;
        }

        public String getAbsFile() {
            return this.path + "/" + this.filename + "." + this.fileType;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            return Objects.equals(this.path, fileInfo.path) && Objects.equals(this.filename, fileInfo.filename) && Objects.equals(this.fileType, fileInfo.fileType);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.filename, this.fileType);
        }

        public String toString() {
            return "FileInfo{path='" + this.path + '\'' + ", filename='" + this.filename + '\'' + ", fileType='" + this.fileType + '\'' + '}';
        }
    }
}

