/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import com.github.hui.quick.plugin.base.BasicFileUtil;
import com.github.hui.quick.plugin.base.HttpUtil;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class FileReadUtil {
    public static String readAll(String fileName) throws IOException {
        BufferedReader reader = FileReadUtil.createLineRead(fileName);
        List lines = reader.lines().collect(Collectors.toList());
        return Joiner.on((String)"\n").join(lines);
    }

    public static InputStream createByteRead(String fileName) throws IOException {
        return FileReadUtil.getStreamByFileName(fileName);
    }

    public static Reader createCharRead(String fileName) throws IOException {
        return new InputStreamReader(FileReadUtil.getStreamByFileName(fileName), Charset.forName("UTF-8"));
    }

    public static BufferedReader createLineRead(String fileName) throws IOException {
        return new BufferedReader(new InputStreamReader(FileReadUtil.getStreamByFileName(fileName), Charset.forName("UTF-8")));
    }

    public static InputStream getStreamByFileName(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName should not be null!");
        }
        if (fileName.startsWith("http")) {
            return HttpUtil.downFile(fileName);
        }
        if (BasicFileUtil.isAbsFile(fileName)) {
            Path path = Paths.get(fileName, new String[0]);
            return Files.newInputStream(path, new OpenOption[0]);
        }
        if (fileName.startsWith("~")) {
            fileName = BasicFileUtil.parseHomeDir2AbsDir(fileName);
            return Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
        }
        return FileReadUtil.class.getClassLoader().getResourceAsStream(fileName);
    }

    private static String bytesToHex(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte aSrc : src) {
            int v = aSrc & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMagicNum(String file) {
        try (InputStream stream = FileReadUtil.getStreamByFileName(file);){
            byte[] b = new byte[28];
            stream.read(b, 0, 28);
            String string = FileReadUtil.bytesToHex(b);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMagicNum(ByteArrayInputStream inputStream) {
        byte[] bytes = new byte[28];
        inputStream.read(bytes, 0, 28);
        inputStream.reset();
        return FileReadUtil.bytesToHex(bytes);
    }
}

