/*
 * Decompiled with CFR 0.152.
 */
package com.github.hui.quick.plugin.base;

import com.github.hui.quick.plugin.base.FileReadUtil;
import com.github.hui.quick.plugin.base.OSUtil;
import com.github.hui.quick.plugin.base.constants.MediaType;
import org.apache.commons.lang3.StringUtils;

public class BasicFileUtil {
    public static boolean isAbsFile(String fileName) {
        if (OSUtil.isWinOS()) {
            return fileName.contains(":") || fileName.startsWith("\\");
        }
        return fileName.startsWith("/");
    }

    public static String parseHomeDir2AbsDir(String path) {
        String homeDir = System.getProperties().getProperty("user.home");
        return StringUtils.replace((String)path, (String)"~", (String)homeDir);
    }

    public static MediaType getMediaType(String path) {
        String magicNum = FileReadUtil.getMagicNum(path);
        if (magicNum == null) {
            return null;
        }
        return MediaType.typeOfMagicNum(magicNum);
    }
}

