/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.common;

import com.mybatis.jpa.common.ColumnNameUtil;
import com.mybatis.jpa.common.FieldReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.ibatis.reflection.ReflectionException;

public class PersistentUtil {
    private static final boolean CAMEL_TO_UNDERLINE = true;

    public static String getTableName(Class<?> clazz) {
        Table table;
        if (clazz.isAnnotationPresent(Table.class) && !(table = clazz.getAnnotation(Table.class)).name().trim().equals("")) {
            return table.name();
        }
        String className = clazz.getSimpleName();
        return ColumnNameUtil.camelToUnderline(className);
    }

    public static String getEntityName(Class<?> type) {
        Entity entity;
        if (type.isAnnotationPresent(Entity.class) && !(entity = type.getAnnotation(Entity.class)).name().trim().equals("")) {
            return entity.name();
        }
        return type.getSimpleName();
    }

    public static String getColumnName(Field field) {
        Column column;
        if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).name().trim().equals("")) {
            return column.name().toUpperCase();
        }
        return ColumnNameUtil.camelToUnderline(field.getName());
    }

    public static Field getPrimaryFieldNotCareNull(Class<?> clazz) {
        Field field = FieldReflectUtil.findField(clazz, Id.class);
        if (field != null) {
            return field;
        }
        return null;
    }

    public static Field getPrimaryField(Class<?> clazz) {
        Field field = PersistentUtil.getPrimaryFieldNotCareNull(clazz);
        if (field != null) {
            return field;
        }
        throw new ReflectionException("no search result for javax.persistence.Id annotation from " + clazz.getName());
    }

    public static String getPrimaryKey(Class<?> clazz) {
        Field primaryField = PersistentUtil.getPrimaryField(clazz);
        return PersistentUtil.getColumnName(primaryField);
    }

    public static Field getFieldByColumnName(Class<?> clazz, String columnName) {
        Map<String, Field> mapping = PersistentUtil.getColumnFieldMapping(clazz);
        Field field = mapping.get(clazz.getName() + "." + columnName);
        if (field == null) {
            throw new ReflectionException("no search matched field to columnName :" + columnName + " from " + clazz.getName());
        }
        return field;
    }

    public static Map<String, Field> getColumnFieldMapping(Class<?> clazz) {
        List<Field> fieldList = PersistentUtil.getPersistentFields(clazz);
        if (fieldList == null || fieldList.isEmpty()) {
            return null;
        }
        HashMap<String, Field> mapping = new HashMap<String, Field>();
        String className = clazz.getName();
        for (Field field : fieldList) {
            mapping.put(className + "." + PersistentUtil.getColumnName(field), field);
        }
        return mapping;
    }

    public static List<Field> getPersistentFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!PersistentUtil.isPersistentField(field)) continue;
                list.add(field);
            }
        }
        return list;
    }

    public static boolean isPersistentField(Field field) {
        return !field.isAnnotationPresent(Transient.class);
    }
}

