/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.OneToOne;

public class AssociationUtil {
    public static Class<?> getTargetType(Field field) {
        OneToOne one;
        if (field.isAnnotationPresent(OneToOne.class) && !(one = field.getAnnotation(OneToOne.class)).targetEntity().equals(Void.TYPE)) {
            return one.targetEntity();
        }
        return Void.TYPE;
    }

    public static String getMappedName(Field field) {
        OneToOne one;
        if (field.isAnnotationPresent(OneToOne.class) && !(one = field.getAnnotation(OneToOne.class)).mappedBy().trim().equals("")) {
            return one.mappedBy();
        }
        return null;
    }

    public static List<Field> getAssociationFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!AssociationUtil.isAssociationField(field)) continue;
                list.add(field);
            }
        }
        return list;
    }

    public static boolean isAssociationField(Field field) {
        return field.isAnnotationPresent(OneToOne.class);
    }
}

