/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.exception.RetrofitExecuteIOException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.util.Assert;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ResponseCallAdapterFactory
extends CallAdapter.Factory {
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Response.class.isAssignableFrom(ResponseCallAdapterFactory.getRawType((Type)returnType))) {
            return new ResponseCallAdapter(returnType);
        }
        return null;
    }

    final class ResponseCallAdapter<R>
    implements CallAdapter<R, Response<R>> {
        private Type returnType;

        ResponseCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            ParameterizedType parameterizedType = (ParameterizedType)this.returnType;
            Object[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Assert.notEmpty((Object[])actualTypeArguments, (String)"Response\u5fc5\u987b\u6307\u5b9a\u6cdb\u578b\u53c2\u6570\uff01");
            return actualTypeArguments[0];
        }

        public Response<R> adapt(Call<R> call) {
            try {
                return call.execute();
            }
            catch (IOException e) {
                throw new RetrofitExecuteIOException(e);
            }
        }
    }
}

