/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value.x680;

import org.asn1s.api.value.Value;
import org.jetbrains.annotations.NotNull;

public final class BooleanValue
implements Value {
    public static final Value TRUE = new BooleanValue(Boolean.TRUE);
    public static final Value FALSE = new BooleanValue(Boolean.FALSE);
    private final Boolean value;

    private BooleanValue(@NotNull Boolean value) {
        this.value = value;
    }

    public boolean asBoolean() {
        return this.value;
    }

    @Override
    @NotNull
    public Value.Kind getKind() {
        return Value.Kind.Boolean;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BooleanValue && this.value.equals(((BooleanValue)obj).asBoolean());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull Value o) {
        if (o.getKind() == Value.Kind.Boolean) {
            return Boolean.compare(this.value, ((BooleanValue)o).asBoolean());
        }
        if (o.getKind() == Value.Kind.Name && o.toNamedValue().getReferenceKind() == Value.Kind.Boolean) {
            return this.compareTo(o.toNamedValue().toBooleanValue());
        }
        return this.getKind().compareTo(o.getKind());
    }

    public String toString() {
        return this.value != false ? "TRUE" : "FALSE";
    }
}

