/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value;

import org.asn1s.api.util.RefUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueName
implements Comparable<ValueName> {
    private final String name;
    private final String moduleName;

    public ValueName(@NotNull String name, @Nullable String moduleName) {
        RefUtils.assertValueRef(name);
        if (moduleName != null) {
            RefUtils.assertTypeRef(moduleName);
        }
        this.name = name;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public int compareTo(@NotNull ValueName o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueName)) {
            return false;
        }
        ValueName valueName = (ValueName)obj;
        if (!this.getName().equals(valueName.getName())) {
            return false;
        }
        return this.getModuleName() != null ? this.getModuleName().equals(valueName.getModuleName()) : valueName.getModuleName() == null;
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + (this.getModuleName() != null ? this.getModuleName().hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.moduleName == null) {
            return this.name;
        }
        return this.moduleName + '.' + this.name;
    }
}

