/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.List;
import org.asn1s.api.Ref;
import org.asn1s.api.type.Type;
import org.asn1s.api.value.ByteArrayValue;
import org.asn1s.api.value.Value;
import org.asn1s.api.value.x680.DateValue;
import org.asn1s.api.value.x680.IntegerValue;
import org.asn1s.api.value.x680.NamedValue;
import org.asn1s.api.value.x680.ObjectIdentifierValue;
import org.asn1s.api.value.x680.OpenTypeValue;
import org.asn1s.api.value.x680.RealValue;
import org.asn1s.api.value.x680.StringValue;
import org.asn1s.api.value.x680.ValueCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueFactory {
    @NotNull
    public RealValue rZero();

    @NotNull
    public RealValue rNegativeZero();

    @NotNull
    public RealValue rPositiveInfinity();

    @NotNull
    public RealValue rNegativeInfinity();

    @NotNull
    public RealValue rNan();

    @NotNull
    public RealValue real(@NotNull String var1);

    @NotNull
    public RealValue real(float var1);

    @NotNull
    public RealValue real(double var1);

    @NotNull
    public RealValue real(@NotNull BigDecimal var1);

    @NotNull
    public RealValue real(long var1, boolean var3, int var4, boolean var5);

    @NotNull
    public RealValue real(BigInteger var1, boolean var2, int var3, boolean var4);

    @NotNull
    public RealValue real(@NotNull IntegerValue var1, boolean var2, @NotNull IntegerValue var3, boolean var4);

    @NotNull
    public IntegerValue integer(@NotNull byte[] var1);

    @NotNull
    public IntegerValue integer(@NotNull String var1);

    @NotNull
    public IntegerValue integer(int var1);

    @NotNull
    public IntegerValue integer(long var1);

    @NotNull
    public IntegerValue integer(@NotNull BigInteger var1);

    @NotNull
    public StringValue cString(@NotNull String var1);

    @NotNull
    public NamedValue named(@NotNull String var1, @Nullable Ref<Value> var2);

    @NotNull
    public ValueCollection collection(boolean var1);

    @NotNull
    public ByteArrayValue hString(@NotNull String var1);

    @NotNull
    public ByteArrayValue bString(@NotNull String var1);

    @NotNull
    public ByteArrayValue byteArrayValue(int var1, @Nullable byte[] var2);

    @NotNull
    public ByteArrayValue emptyByteArray();

    @NotNull
    public OpenTypeValue openTypeValue(@NotNull Ref<Type> var1, @NotNull Ref<Value> var2);

    @NotNull
    public DateValue timeValue(@NotNull Instant var1);

    @NotNull
    public ObjectIdentifierValue objectIdentifier(@NotNull List<Ref<Value>> var1);
}

