/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.value;

import org.asn1s.api.Ref;
import org.asn1s.api.Scope;
import org.asn1s.api.exception.ResolutionException;
import org.asn1s.api.value.ByteArrayValue;
import org.asn1s.api.value.x680.BooleanValue;
import org.asn1s.api.value.x680.DateValue;
import org.asn1s.api.value.x680.IntegerValue;
import org.asn1s.api.value.x680.NamedValue;
import org.asn1s.api.value.x680.NullValue;
import org.asn1s.api.value.x680.ObjectIdentifierValue;
import org.asn1s.api.value.x680.OpenTypeValue;
import org.asn1s.api.value.x680.RealValue;
import org.asn1s.api.value.x680.StringValue;
import org.asn1s.api.value.x680.ValueCollection;
import org.asn1s.api.value.x681.ObjectValue;
import org.jetbrains.annotations.NotNull;

public interface Value
extends Ref<Value>,
Comparable<Value> {
    @NotNull
    public Kind getKind();

    default public boolean isEqualTo(Value value) {
        return this.compareTo(value) == 0;
    }

    default public BooleanValue toBooleanValue() {
        return (BooleanValue)this;
    }

    default public IntegerValue toIntegerValue() {
        return (IntegerValue)this;
    }

    default public RealValue toRealValue() {
        return (RealValue)this;
    }

    default public NullValue toNullValue() {
        return (NullValue)this;
    }

    default public NamedValue toNamedValue() {
        return (NamedValue)this;
    }

    default public ValueCollection toValueCollection() {
        return (ValueCollection)this;
    }

    default public StringValue toStringValue() {
        return (StringValue)this;
    }

    default public DateValue toDateValue() {
        return (DateValue)this;
    }

    default public ByteArrayValue toByteArrayValue() {
        return (ByteArrayValue)this;
    }

    default public ObjectValue toObjectValue() {
        return (ObjectValue)this;
    }

    default public ObjectIdentifierValue toObjectIdentifierValue() {
        return (ObjectIdentifierValue)this;
    }

    default public OpenTypeValue toOpenTypeValue() {
        return (OpenTypeValue)this;
    }

    @Override
    default public Value resolve(Scope scope) throws ResolutionException {
        return this;
    }

    public static enum Kind {
        Boolean,
        ByteArray,
        CString,
        Collection,
        Empty,
        Integer,
        Iri,
        Name,
        NamedCollection,
        Null,
        Object,
        Oid,
        OpenType,
        Real,
        TemplateInstance,
        Time;

    }
}

