/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class TimeUtils {
    public static final String UTC_TIME_FORMAT = "yyMMddHHmmss";
    public static final String GENERALIZED_TIME_FORMAT = "yyyyMMddHHmmss.SSS";
    private static final String UTC_FORMAT = "yyMMddHHmm";
    private static final String UTC_FORMAT_TZ = "yyMMddHHmmZ";
    private static final String UTC_FORMAT_S = "yyMMddHHmmss";
    private static final String UTC_FORMAT_S_TZ = "yyMMddHHmmssZ";
    private static final Pattern UTC_PATTERN = Pattern.compile("[0-9]{2}(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])([0-1][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])?(Z|[+\\-]([0-1][0-9]|2[0-3])([0-5][0-9]))?");
    private static final String G_FORMAT = "yyyyMMddHH";
    private static final String G_FORMAT_M = "yyyyMMddHHmm";
    private static final String G_FORMAT_M_S = "yyyyMMddHHmmss";
    private static final Pattern G_PATTERN = Pattern.compile("[0-9]{4}(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])([0-1][0-9]|2[0-3])(([0-5][0-9])([0-5][0-9])?)?([.,][0-9]+)?(Z||[+\\-]([0-1][0-9]|2[0-3])([0-5][0-9]))?");
    private static final String TIME_FORMAT = "HHmmss";
    private static final String TIME_FORMAT_COLONS = "HH:mm:ss";
    private static final Pattern TIME_PATTERN = Pattern.compile("(([0-1][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])|([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]))");
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])");
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MINUTES_IN_HOUR = 60;

    private TimeUtils() {
    }

    @NotNull
    public static String formatInstant(TemporalAccessor instant, String format, boolean optimize) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("GMT"));
        String result = formatter.format(instant);
        if (result.indexOf(46) > 0) {
            if (result.endsWith(".000")) {
                result = result.substring(0, result.length() - 4);
            } else if (result.endsWith("00")) {
                result = result.substring(0, result.length() - 2);
            } else if (result.endsWith("0")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        if (optimize && result.endsWith("00")) {
            result = result.substring(0, result.length() - 2);
        }
        result = result + "Z";
        return result;
    }

    public static boolean isTimeValue(CharSequence value) {
        return TimeUtils.isUTCTimeValue(value) || TimeUtils.isGeneralizedTimeValue(value) || TIME_PATTERN.matcher(value).matches() || DATE_PATTERN.matcher(value).matches();
    }

    public static boolean isUTCTimeValue(CharSequence value) {
        return UTC_PATTERN.matcher(value).matches();
    }

    public static boolean isGeneralizedTimeValue(CharSequence value) {
        return G_PATTERN.matcher(value).matches();
    }

    public static Instant parseGeneralizedTime(String value) {
        if (!TimeUtils.isGeneralizedTimeValue(value)) {
            throw new IllegalArgumentException("Not an GeneralizedTime string: " + value);
        }
        return TimeUtils.fromGeneralized(value).atZone(ZoneId.of("GMT")).toInstant();
    }

    public static Instant parseUTCTime(String value) {
        if (!TimeUtils.isUTCTimeValue(value)) {
            throw new IllegalArgumentException("Not an UTCTime string: " + value);
        }
        return TimeUtils.fromUTC(value).atZone(ZoneId.of("GMT")).toInstant();
    }

    public static Instant parseUnknownTime(String value) {
        if (TimeUtils.isUTCTimeValue(value = value.replace(',', '.'))) {
            return TimeUtils.fromUTC(value);
        }
        if (TimeUtils.isGeneralizedTimeValue(value)) {
            return TimeUtils.fromGeneralized(value);
        }
        if (TIME_PATTERN.matcher(value).matches()) {
            return DateTimeFormatter.ofPattern(value.indexOf(58) == -1 ? TIME_FORMAT : TIME_FORMAT_COLONS).parse((CharSequence)value, Instant::from);
        }
        if (DATE_PATTERN.matcher(value).matches()) {
            return DateTimeFormatter.ofPattern(DATE_FORMAT).parse((CharSequence)value, Instant::from);
        }
        throw new IllegalArgumentException("Not an time value: " + value);
    }

    private static Instant fromUTC(String value) {
        if (value.endsWith("Z") || value.indexOf(45) == -1 && value.indexOf(43) == -1) {
            String string = value = value.endsWith("Z") ? value.substring(0, value.length() - 1) : value;
            if (value.length() == 10) {
                return DateTimeFormatter.ofPattern(UTC_FORMAT).withZone(ZoneId.of("GMT")).parse((CharSequence)value, Instant::from);
            }
            return DateTimeFormatter.ofPattern("yyMMddHHmmss").withZone(ZoneId.of("GMT")).parse((CharSequence)value, Instant::from);
        }
        int idx = value.replace('-', '+').indexOf(43);
        if (idx == 10) {
            return DateTimeFormatter.ofPattern(UTC_FORMAT_TZ).parse((CharSequence)value, Instant::from);
        }
        return DateTimeFormatter.ofPattern(UTC_FORMAT_S_TZ).parse((CharSequence)value, Instant::from);
    }

    private static Instant fromGeneralized(String value) {
        if (value.indexOf(46) == -1) {
            return TimeUtils.parseGeneralizedImpl(value);
        }
        int idx = value.indexOf(46);
        int end = idx + 1;
        char c = value.charAt(end);
        while (Character.isDigit(c) && value.length() != ++end) {
            c = value.charAt(end);
        }
        String noFracture = value.length() == end ? value.substring(0, idx) : value.substring(0, idx) + value.substring(end);
        String fracturePart = value.substring(idx + 1, end);
        double fracture = (double)Long.parseLong(fracturePart) / StrictMath.pow(10.0, fracturePart.length());
        Instant instant = TimeUtils.parseGeneralizedImpl(noFracture);
        instant = idx == 10 ? TimeUtils.appendFractureMinutes(instant, fracture) : (idx == 12 ? TimeUtils.appendFractureSeconds(instant, fracture) : TimeUtils.appendFractureMillis(instant, fracture));
        return instant;
    }

    private static Instant appendFractureMinutes(Instant instant, double fracture) {
        double rawMinutes = 60.0 * fracture;
        long minutes = (long)rawMinutes;
        if (minutes != 0L) {
            instant = instant.plus(minutes, ChronoUnit.MINUTES);
        }
        return TimeUtils.appendFractureSeconds(instant, TimeUtils.fraction(rawMinutes));
    }

    private static Instant appendFractureSeconds(Instant instant, double fraction) {
        double rawSeconds = 60.0 * fraction;
        long seconds = (long)rawSeconds;
        if (seconds != 0L) {
            instant = instant.plus(seconds, ChronoUnit.SECONDS);
        }
        return TimeUtils.appendFractureMillis(instant, TimeUtils.fraction(rawSeconds));
    }

    private static Instant appendFractureMillis(Instant instant, double fraction) {
        long millis = (long)(1000.0 * fraction);
        if (millis != 0L) {
            return instant.plus(millis, ChronoUnit.MILLIS);
        }
        return instant;
    }

    private static double fraction(double value) {
        return value % 1.0;
    }

    private static Instant parseGeneralizedImpl(String value) {
        if (value.endsWith("Z")) {
            value = value.substring(0, value.length() - 1);
            return TimeUtils.generalizedToInstant(value, value.length(), false);
        }
        int idx = value.replace('-', '+').indexOf(43);
        if (idx == -1) {
            return TimeUtils.generalizedToInstant(value, value.length(), false);
        }
        return TimeUtils.generalizedToInstant(value, idx, true);
    }

    private static Instant generalizedToInstant(CharSequence value, int length, boolean withTz) {
        DateTimeFormatter formatter = length == 10 ? DateTimeFormatter.ofPattern(withTz ? "yyyyMMddHHZ" : G_FORMAT) : (length == 12 ? DateTimeFormatter.ofPattern(withTz ? "yyyyMMddHHmmZ" : G_FORMAT_M) : DateTimeFormatter.ofPattern(withTz ? "yyyyMMddHHmmssZ" : G_FORMAT_M_S));
        if (!withTz) {
            formatter = formatter.withZone(ZoneId.of("GMT"));
        }
        return formatter.parse(value, Instant::from);
    }
}

