/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.type;

import org.asn1s.api.Ref;
import org.asn1s.api.Scope;
import org.asn1s.api.exception.ResolutionException;
import org.asn1s.api.type.DefinedType;
import org.asn1s.api.type.Type;
import org.asn1s.api.type.TypeName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNameRef
implements Ref<Type> {
    private final TypeName name;

    public TypeNameRef(@NotNull String name, @Nullable String moduleName) {
        this(new TypeName(name, moduleName));
    }

    public TypeNameRef(@NotNull TypeName name) {
        this.name = name;
    }

    public String getName() {
        return this.name.getName();
    }

    public String getModuleName() {
        return this.name.getModuleName();
    }

    @Override
    public Type resolve(Scope scope) throws ResolutionException {
        DefinedType type = scope.resolveBuiltinTypeOrNull(this.name);
        if (type != null) {
            return type;
        }
        return scope.resolveType(this.name);
    }

    public String toString() {
        return this.name.toString();
    }
}

