/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.type;

import org.asn1s.api.Ref;
import org.asn1s.api.Scope;
import org.asn1s.api.exception.ResolutionException;
import org.asn1s.api.type.ClassFieldType;
import org.asn1s.api.type.NamedType;
import org.asn1s.api.type.Type;

public class ClassFieldRef
implements Ref<Type> {
    private final Ref<Type> classTypeRef;
    private final String name;

    public ClassFieldRef(Ref<Type> classTypeRef, String name) {
        this.classTypeRef = classTypeRef;
        this.name = name;
    }

    @Override
    public Type resolve(Scope scope) throws ResolutionException {
        Type type = this.classTypeRef.resolve(scope);
        assert (type != null);
        NamedType field = type.getNamedType(this.name);
        if (!(field instanceof ClassFieldType)) {
            throw new ResolutionException("There is no field '" + this.name + "' in type: " + this.classTypeRef);
        }
        return field;
    }

    public String toString() {
        return this.classTypeRef + "." + this.name;
    }
}

