/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.encoding.tag;

import org.asn1s.api.Ref;
import org.asn1s.api.Scope;
import org.asn1s.api.UniversalType;
import org.asn1s.api.encoding.EncodingInstructions;
import org.asn1s.api.encoding.IEncoding;
import org.asn1s.api.encoding.tag.Tag;
import org.asn1s.api.encoding.tag.TagClass;
import org.asn1s.api.encoding.tag.TagMethod;
import org.asn1s.api.exception.ResolutionException;
import org.asn1s.api.util.RefUtils;
import org.asn1s.api.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TagEncoding
implements IEncoding {
    private final TagMethod moduleTagMethod;
    private final TagMethod tagMethod;
    private final TagClass tagClass;

    public static TagEncoding application(int tagNumber) {
        return new ResolvedTagEncoding(TagMethod.Unknown, TagMethod.Unknown, TagClass.Application, tagNumber);
    }

    public static TagEncoding context(int tagNumber, TagMethod tagMethod) {
        return new ResolvedTagEncoding(TagMethod.Unknown, tagMethod, TagClass.ContextSpecific, tagNumber);
    }

    public static TagEncoding universal(UniversalType type) {
        return new ResolvedTagEncoding(TagMethod.Unknown, TagMethod.Unknown, TagClass.Universal, type.tagNumber());
    }

    public static TagEncoding create(@NotNull TagMethod moduleTagMethod, @NotNull TagMethod tagMethod, @Nullable TagClass tagClass, int tagNumber) {
        return new ResolvedTagEncoding(moduleTagMethod, tagMethod, tagClass, tagNumber);
    }

    public static TagEncoding create(@NotNull TagMethod moduleTagMethod, @NotNull TagMethod tagMethod, @Nullable TagClass tagClass, Ref<Value> tagNumberRef) {
        return new UnresolvedTagEncoding(moduleTagMethod, tagMethod, tagClass, tagNumberRef);
    }

    protected TagEncoding(TagMethod tagMethod, TagClass tagClass) {
        this(TagMethod.Unknown, tagMethod, tagClass);
    }

    TagEncoding(@NotNull TagMethod moduleTagMethod, @NotNull TagMethod tagMethod, @Nullable TagClass tagClass) {
        this.moduleTagMethod = moduleTagMethod;
        this.tagMethod = tagMethod;
        this.tagClass = tagClass == null ? TagClass.Application : tagClass;
    }

    public TagClass getTagClass() {
        return this.tagClass;
    }

    public TagMethod getTagMethod() {
        if (this.tagMethod != TagMethod.Unknown) {
            return this.tagMethod;
        }
        if (this.moduleTagMethod == TagMethod.Explicit || this.moduleTagMethod == TagMethod.Unknown) {
            return TagMethod.Explicit;
        }
        return TagMethod.Implicit;
    }

    public TagMethod getTagMethodDirect() {
        return this.tagMethod;
    }

    public TagMethod getModuleTagMethod() {
        return this.moduleTagMethod;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TagEncoding && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.tagMethod == TagMethod.Unknown) {
            return "[ " + this.tagClass.name().toUpperCase() + ' ' + this.getTagNumber() + " ]";
        }
        return "[ " + this.tagClass.name().toUpperCase() + ' ' + this.getTagNumber() + " ] " + this.tagMethod.name().toUpperCase();
    }

    @Override
    public EncodingInstructions getEncodingInstructions() {
        return EncodingInstructions.Tag;
    }

    public abstract int getTagNumber();

    public Tag toTag(boolean constructed) {
        return new Tag(this.getTagClass(), constructed, this.getTagNumber());
    }

    private static final class UnresolvedTagEncoding
    extends TagEncoding {
        private final Ref<Value> tagNumberRef;

        private UnresolvedTagEncoding(@NotNull TagMethod moduleTagMethod, @NotNull TagMethod tagMethod, @Nullable TagClass tagClass, Ref<Value> tagNumberRef) {
            super(moduleTagMethod, tagMethod, tagClass);
            this.tagNumberRef = tagNumberRef;
        }

        @Override
        public IEncoding resolve(@NotNull Scope scope) throws ResolutionException {
            Value value = RefUtils.toBasicValue(scope, this.tagNumberRef);
            if (value.getKind() != Value.Kind.Integer || !value.toIntegerValue().isInt()) {
                throw new ResolutionException("Only integer values supported for tags that may be cast to Integer java type");
            }
            int tagNumber = value.toIntegerValue().asInt();
            if (tagNumber < 0) {
                throw new ResolutionException("Tag number must be positive or zero");
            }
            return new ResolvedTagEncoding(this.getModuleTagMethod(), this.getTagMethod(), this.getTagClass(), tagNumber);
        }

        @Override
        public int getTagNumber() {
            throw new UnsupportedOperationException("Must resolve first");
        }
    }

    private static final class ResolvedTagEncoding
    extends TagEncoding {
        private final int tagNumber;

        private ResolvedTagEncoding(@NotNull TagMethod moduleTagMethod, @NotNull TagMethod tagMethod, @Nullable TagClass tagClass, int tagNumber) {
            super(moduleTagMethod, tagMethod, tagClass);
            this.tagNumber = tagNumber;
        }

        @Override
        public IEncoding resolve(@NotNull Scope scope) {
            return this;
        }

        @Override
        public int getTagNumber() {
            return this.tagNumber;
        }
    }
}

