/*
 * Decompiled with CFR 0.152.
 */
package org.asn1s.api.encoding.tag;

import org.asn1s.api.encoding.tag.TagClass;
import org.asn1s.api.encoding.tag.TagEncoding;

public final class Tag {
    private final TagClass tagClass;
    private final boolean constructed;
    private final int tagNumber;

    public Tag(TagEncoding encoding, boolean constructed) {
        this(encoding.getTagClass(), constructed, encoding.getTagNumber());
    }

    public Tag(TagClass tagClass, boolean constructed, int tagNumber) {
        this.tagClass = tagClass;
        this.constructed = constructed;
        this.tagNumber = tagNumber;
    }

    public TagClass getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)obj;
        if (this.isConstructed() != tag.isConstructed()) {
            return false;
        }
        if (this.getTagNumber() != tag.getTagNumber()) {
            return false;
        }
        return this.getTagClass() == tag.getTagClass();
    }

    public int hashCode() {
        int result = this.getTagClass().hashCode();
        result = 31 * result + (this.isConstructed() ? 1 : 0);
        result = 31 * result + this.getTagNumber();
        return result;
    }

    public void assertEoc() {
        if (!this.isEoc()) {
            throw new IllegalStateException("EOC required");
        }
    }

    public boolean isEoc() {
        return this.tagClass == TagClass.Universal && !this.constructed && this.tagNumber == 0;
    }

    public String toString() {
        return "Tag{tagClass=" + (Object)((Object)this.tagClass) + ", constructed=" + this.constructed + ", tagNumber=" + this.tagNumber + '}';
    }
}

