/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.persistence;

import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.common.constants.StoreStrategy;
import com.github.kfcfans.powerjob.worker.common.utils.OmsWorkerFileUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.h2.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private static volatile DataSource dataSource;
    private static final String H2_PATH;
    private static final String DISK_JDBC_URL;
    private static final String MEMORY_JDBC_URL;

    public static Connection getConnection() throws SQLException {
        return ConnectionFactory.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource getDataSource() {
        if (dataSource != null) {
            return dataSource;
        }
        Class<ConnectionFactory> clazz = ConnectionFactory.class;
        synchronized (ConnectionFactory.class) {
            if (dataSource == null) {
                StoreStrategy strategy = OhMyWorker.getConfig() == null ? StoreStrategy.DISK : OhMyWorker.getConfig().getStoreStrategy();
                HikariConfig config = new HikariConfig();
                config.setDriverClassName(Driver.class.getName());
                config.setJdbcUrl(strategy == StoreStrategy.DISK ? DISK_JDBC_URL : MEMORY_JDBC_URL);
                config.setAutoCommit(true);
                config.setMinimumIdle(2);
                config.setMaximumPoolSize(32);
                dataSource = new HikariDataSource(config);
                log.info("[OmsDatasource] init h2 datasource successfully, use url: {}", (Object)config.getJdbcUrl());
                try {
                    FileUtils.forceDeleteOnExit((File)new File(H2_PATH));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataSource;
        }
    }

    static {
        H2_PATH = OmsWorkerFileUtils.getH2WorkDir();
        DISK_JDBC_URL = String.format("jdbc:h2:file:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", H2_PATH);
        MEMORY_JDBC_URL = String.format("jdbc:h2:mem:%spowerjob_worker_db;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false", H2_PATH);
    }
}

