/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.log.impl;

import com.github.kfcfans.powerjob.worker.background.OmsLogHandler;
import com.github.kfcfans.powerjob.worker.log.OmsLogger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class OmsServerLogger
implements OmsLogger {
    private final long instanceId;
    private static final String LOG_PREFIX = "{} ";

    @Override
    public void debug(String messagePattern, Object ... args) {
        this.process("DEBUG", messagePattern, args);
    }

    @Override
    public void info(String messagePattern, Object ... args) {
        this.process("INFO", messagePattern, args);
    }

    @Override
    public void warn(String messagePattern, Object ... args) {
        this.process("WARN", messagePattern, args);
    }

    @Override
    public void error(String messagePattern, Object ... args) {
        this.process("ERROR", messagePattern, args);
    }

    private static String genLog(String level, String messagePattern, Object ... arg) {
        String pattern = LOG_PREFIX + messagePattern;
        Object[] newArgs = new Object[arg.length + 1];
        newArgs[0] = level;
        System.arraycopy(arg, 0, newArgs, 1, arg.length);
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)pattern, (Object[])newArgs);
        if (formattingTuple.getThrowable() != null) {
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)formattingTuple.getThrowable());
            return formattingTuple.getMessage() + System.lineSeparator() + stackTrace;
        }
        return formattingTuple.getMessage();
    }

    private void process(String level, String messagePattern, Object ... args) {
        String logContent = OmsServerLogger.genLog(level, messagePattern, args);
        OmsLogHandler.INSTANCE.submitLog(this.instanceId, logContent);
    }

    public OmsServerLogger(long instanceId) {
        this.instanceId = instanceId;
    }
}

