/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.tracker.task;

import akka.actor.ActorSelection;
import com.github.kfcfans.powerjob.common.ExecuteType;
import com.github.kfcfans.powerjob.common.InstanceStatus;
import com.github.kfcfans.powerjob.common.OmsException;
import com.github.kfcfans.powerjob.common.TimeExpressionType;
import com.github.kfcfans.powerjob.common.model.InstanceDetail;
import com.github.kfcfans.powerjob.common.request.ServerScheduleJobReq;
import com.github.kfcfans.powerjob.common.request.TaskTrackerReportInstanceStatusReq;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.common.constants.TaskStatus;
import com.github.kfcfans.powerjob.worker.common.utils.AkkaUtils;
import com.github.kfcfans.powerjob.worker.common.utils.LRUCache;
import com.github.kfcfans.powerjob.worker.core.tracker.task.TaskTracker;
import com.github.kfcfans.powerjob.worker.persistence.TaskDO;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class FrequentTaskTracker
extends TaskTracker {
    private static final Logger log = LoggerFactory.getLogger(FrequentTaskTracker.class);
    private TimeExpressionType timeExpressionType;
    private long timeParams;
    private int maxInstanceNum;
    private AtomicLong triggerTimes;
    private AtomicLong succeedTimes;
    private AtomicLong failedTimes;
    private Launcher launcher;
    private LRUCache<Long, SubInstanceInfo> recentSubInstanceInfo;
    private Map<Long, SubInstanceTimeHolder> subInstanceId2TimeHolder;
    private static final int HISTORY_SIZE = 10;
    private static final String LAST_TASK_ID_PREFIX = "L";
    private static final int MIN_INTERVAL = 1000;

    protected FrequentTaskTracker(ServerScheduleJobReq req) {
        super(req);
    }

    @Override
    protected void initTaskTracker(ServerScheduleJobReq req) {
        this.timeExpressionType = TimeExpressionType.valueOf((String)req.getTimeExpressionType());
        this.timeParams = Long.parseLong(req.getTimeExpression());
        this.maxInstanceNum = req.getMaxInstanceNum();
        this.triggerTimes = new AtomicLong(0L);
        this.succeedTimes = new AtomicLong(0L);
        this.failedTimes = new AtomicLong(0L);
        this.recentSubInstanceInfo = new LRUCache(10);
        this.subInstanceId2TimeHolder = Maps.newConcurrentMap();
        String poolName = String.format("ftttp-%d", req.getInstanceId()) + "-%d";
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(poolName).build();
        this.scheduledPool = Executors.newScheduledThreadPool(3, factory);
        this.launcher = new Launcher();
        if (this.timeExpressionType == TimeExpressionType.FIX_RATE) {
            if (this.timeParams < 1000L) {
                throw new OmsException("time interval too small, please set the timeExpressionInfo >= 1000");
            }
            this.scheduledPool.scheduleAtFixedRate(this.launcher, 1L, this.timeParams, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledPool.schedule(this.launcher, 0L, TimeUnit.MILLISECONDS);
        }
        this.scheduledPool.scheduleWithFixedDelay(new TaskTracker.Dispatcher(this), 1L, 2L, TimeUnit.SECONDS);
        this.scheduledPool.scheduleWithFixedDelay(new Checker(), 5000L, Math.min(Math.max(this.timeParams, 5000L), 15000L), TimeUnit.MILLISECONDS);
    }

    @Override
    public InstanceDetail fetchRunningStatus() {
        InstanceDetail detail = new InstanceDetail();
        detail.setActualTriggerTime(Long.valueOf(this.createTime));
        detail.setStatus(Integer.valueOf(InstanceStatus.RUNNING.getV()));
        detail.setTaskTrackerAddress(OhMyWorker.getWorkerAddress());
        LinkedList history = Lists.newLinkedList();
        this.recentSubInstanceInfo.forEach((subId, subInstanceInfo) -> {
            InstanceDetail.SubInstanceDetail subDetail = new InstanceDetail.SubInstanceDetail();
            BeanUtils.copyProperties((Object)subInstanceInfo, (Object)subDetail);
            InstanceStatus status = InstanceStatus.of((int)((SubInstanceInfo)subInstanceInfo).status);
            subDetail.setStatus(status.getV());
            subDetail.setSubInstanceId(subId.longValue());
            history.add(subDetail);
        });
        detail.setSubInstanceDetails((List)history);
        return detail;
    }

    private void processFinishedSubInstance(long subInstanceId, boolean success, String result) {
        if (success) {
            this.succeedTimes.incrementAndGet();
        } else {
            this.failedTimes.incrementAndGet();
        }
        this.subInstanceId2TimeHolder.remove(subInstanceId);
        SubInstanceInfo subInstanceInfo = this.recentSubInstanceInfo.get(subInstanceId);
        if (subInstanceInfo != null) {
            subInstanceInfo.status = success ? InstanceStatus.SUCCEED.getV() : InstanceStatus.FAILED.getV();
            subInstanceInfo.result = result;
            subInstanceInfo.finishedTime = System.currentTimeMillis();
        }
        this.taskPersistenceService.deleteAllSubInstanceTasks(this.instanceId, subInstanceId);
        if (this.timeExpressionType == TimeExpressionType.FIX_DELAY) {
            this.scheduledPool.schedule(this.launcher, this.timeParams, TimeUnit.MILLISECONDS);
        }
    }

    private static class SubInstanceTimeHolder {
        private long startTime;
        private long lastActiveTime;

        private SubInstanceTimeHolder() {
        }
    }

    private static class SubInstanceInfo {
        private int status;
        private long startTime;
        private long finishedTime;
        private String result;

        public int getStatus() {
            return this.status;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinishedTime() {
            return this.finishedTime;
        }

        public String getResult() {
            return this.result;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setFinishedTime(long finishedTime) {
            this.finishedTime = finishedTime;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubInstanceInfo)) {
                return false;
            }
            SubInstanceInfo other = (SubInstanceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            if (this.getStartTime() != other.getStartTime()) {
                return false;
            }
            if (this.getFinishedTime() != other.getFinishedTime()) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubInstanceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            long $startTime = this.getStartTime();
            result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
            long $finishedTime = this.getFinishedTime();
            result = result * 59 + (int)($finishedTime >>> 32 ^ $finishedTime);
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FrequentTaskTracker.SubInstanceInfo(status=" + this.getStatus() + ", startTime=" + this.getStartTime() + ", finishedTime=" + this.getFinishedTime() + ", result=" + this.getResult() + ")";
        }
    }

    private class Checker
    implements Runnable {
        private static final long HEARTBEAT_TIMEOUT_MS = 60000L;

        private Checker() {
        }

        @Override
        public void run() {
            if (FrequentTaskTracker.this.finished.get()) {
                return;
            }
            try {
                this.checkStatus();
                this.reportStatus();
            }
            catch (Exception e) {
                log.warn("[TaskTracker-{}] check and report status failed.", (Object)FrequentTaskTracker.this.instanceId, (Object)e);
            }
        }

        private void checkStatus() {
            Stopwatch stopwatch = Stopwatch.createStarted();
            ExecuteType executeType = ExecuteType.valueOf((String)FrequentTaskTracker.this.instanceInfo.getExecuteType());
            long instanceTimeoutMS = FrequentTaskTracker.this.instanceInfo.getInstanceTimeoutMS();
            long nowTS = System.currentTimeMillis();
            Iterator iterator = FrequentTaskTracker.this.subInstanceId2TimeHolder.entrySet().iterator();
            block4: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Long subInstanceId = (Long)entry.getKey();
                SubInstanceTimeHolder timeHolder = (SubInstanceTimeHolder)entry.getValue();
                long executeTimeout = nowTS - timeHolder.startTime;
                long heartbeatTimeout = nowTS - timeHolder.lastActiveTime;
                if (executeTimeout > instanceTimeoutMS || heartbeatTimeout > 60000L) {
                    this.onFinished(subInstanceId, false, "TIMEOUT", iterator);
                    continue;
                }
                TaskTracker.InstanceStatisticsHolder holder = FrequentTaskTracker.this.getInstanceStatisticsHolder(subInstanceId);
                long finishedNum = holder.succeedNum + holder.failedNum;
                long unfinishedNum = holder.waitingDispatchNum + holder.workerUnreceivedNum + holder.receivedNum + holder.runningNum;
                if (unfinishedNum == 0L) {
                    if (finishedNum == 0L) {
                        this.onFinished(subInstanceId, false, "LAUNCH_FAILED", iterator);
                        continue;
                    }
                    switch (executeType) {
                        case STANDALONE: {
                            TaskDO resultTask = FrequentTaskTracker.this.taskPersistenceService.getAllTask(FrequentTaskTracker.this.instanceId, subInstanceId).get(0);
                            boolean success = resultTask.getStatus().intValue() == TaskStatus.WORKER_PROCESS_SUCCESS.getValue();
                            this.onFinished(subInstanceId, success, resultTask.getResult(), iterator);
                            continue block4;
                        }
                        case MAP: {
                            String result = String.format("total:%d,succeed:%d,failed:%d", holder.getTotalTaskNum(), holder.succeedNum, holder.failedNum);
                            this.onFinished(subInstanceId, holder.failedNum == 0L, result, iterator);
                            continue block4;
                        }
                    }
                    Optional<TaskDO> lastTaskOptional = FrequentTaskTracker.this.taskPersistenceService.getLastTask(FrequentTaskTracker.this.instanceId, subInstanceId);
                    if (lastTaskOptional.isPresent()) {
                        TaskStatus lastTaskStatus = TaskStatus.of(lastTaskOptional.get().getStatus());
                        if (lastTaskStatus == TaskStatus.WORKER_PROCESS_SUCCESS || lastTaskStatus == TaskStatus.WORKER_PROCESS_FAILED) {
                            this.onFinished(subInstanceId, lastTaskStatus == TaskStatus.WORKER_PROCESS_SUCCESS, lastTaskOptional.get().getResult(), iterator);
                        }
                    } else {
                        TaskDO newLastTask = new TaskDO();
                        newLastTask.setTaskName("OMS_LAST_TASK");
                        newLastTask.setTaskId(FrequentTaskTracker.LAST_TASK_ID_PREFIX + subInstanceId);
                        newLastTask.setSubInstanceId(subInstanceId);
                        newLastTask.setAddress(OhMyWorker.getWorkerAddress());
                        FrequentTaskTracker.this.submitTask(Lists.newArrayList((Object[])new TaskDO[]{newLastTask}));
                    }
                }
                log.debug("[TaskTracker-{}] check status using {}.", (Object)FrequentTaskTracker.this.instanceId, (Object)stopwatch.stop());
            }
        }

        private void reportStatus() {
            if (StringUtils.isEmpty((Object)OhMyWorker.getCurrentServer())) {
                return;
            }
            TaskTrackerReportInstanceStatusReq req = new TaskTrackerReportInstanceStatusReq();
            req.setJobId(FrequentTaskTracker.this.instanceInfo.getJobId());
            req.setInstanceId(Long.valueOf(FrequentTaskTracker.this.instanceId));
            req.setReportTime(System.currentTimeMillis());
            req.setStartTime(FrequentTaskTracker.this.createTime);
            req.setInstanceStatus(InstanceStatus.RUNNING.getV());
            req.setTotalTaskNum(FrequentTaskTracker.this.triggerTimes.get());
            req.setSucceedTaskNum(FrequentTaskTracker.this.succeedTimes.get());
            req.setFailedTaskNum(FrequentTaskTracker.this.failedTimes.get());
            req.setSourceAddress(OhMyWorker.getWorkerAddress());
            String serverPath = AkkaUtils.getAkkaServerPath("server_actor");
            if (StringUtils.isEmpty((Object)serverPath)) {
                return;
            }
            ActorSelection serverActor = OhMyWorker.actorSystem.actorSelection(serverPath);
            serverActor.tell((Object)req, null);
        }

        private void onFinished(Long subInstanceId, boolean success, String result, Iterator<?> iterator) {
            iterator.remove();
            FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, success, result);
        }
    }

    private class Launcher
    implements Runnable {
        private Launcher() {
        }

        public void innerRun() {
            if (FrequentTaskTracker.this.finished.get()) {
                return;
            }
            Long subInstanceId = FrequentTaskTracker.this.triggerTimes.incrementAndGet();
            SubInstanceTimeHolder timeHolder = new SubInstanceTimeHolder();
            timeHolder.startTime = (timeHolder.lastActiveTime = System.currentTimeMillis());
            FrequentTaskTracker.this.subInstanceId2TimeHolder.put(subInstanceId, timeHolder);
            SubInstanceInfo subInstanceInfo = new SubInstanceInfo();
            subInstanceInfo.status = TaskStatus.DISPATCH_SUCCESS_WORKER_UNCHECK.getValue();
            subInstanceInfo.startTime = timeHolder.startTime;
            FrequentTaskTracker.this.recentSubInstanceInfo.put(subInstanceId, subInstanceInfo);
            String myAddress = OhMyWorker.getWorkerAddress();
            String taskId = String.valueOf(subInstanceId);
            TaskDO newRootTask = new TaskDO();
            newRootTask.setInstanceId(FrequentTaskTracker.this.instanceId);
            newRootTask.setSubInstanceId(subInstanceId);
            newRootTask.setTaskId(taskId);
            newRootTask.setStatus(TaskStatus.DISPATCH_SUCCESS_WORKER_UNCHECK.getValue());
            newRootTask.setFailedCnt(0);
            newRootTask.setAddress(myAddress);
            newRootTask.setTaskName("OMS_ROOT_TASK");
            newRootTask.setCreatedTime(System.currentTimeMillis());
            newRootTask.setLastModifiedTime(System.currentTimeMillis());
            newRootTask.setLastReportTime(-1L);
            if (FrequentTaskTracker.this.maxInstanceNum > 0 && FrequentTaskTracker.this.timeExpressionType == TimeExpressionType.FIX_RATE && FrequentTaskTracker.this.subInstanceId2TimeHolder.size() > FrequentTaskTracker.this.maxInstanceNum) {
                log.warn("[TaskTracker-{}] cancel to launch the subInstance({}) due to too much subInstance is running.", (Object)FrequentTaskTracker.this.instanceId, (Object)subInstanceId);
                FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, false, "TOO_MUCH_INSTANCE");
                return;
            }
            if (!FrequentTaskTracker.this.taskPersistenceService.save(newRootTask)) {
                log.error("[TaskTracker-{}] Launcher create new root task failed.", (Object)FrequentTaskTracker.this.instanceId);
                FrequentTaskTracker.this.processFinishedSubInstance(subInstanceId, false, "LAUNCH_FAILED");
                return;
            }
            FrequentTaskTracker.this.dispatchTask(newRootTask, myAddress);
        }

        @Override
        public void run() {
            try {
                this.innerRun();
            }
            catch (Exception e) {
                log.error("[TaskTracker-{}] launch task failed.", (Object)FrequentTaskTracker.this.instanceId, (Object)e);
            }
        }
    }
}

