/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.tracker.processor;

import com.github.kfcfans.powerjob.worker.core.tracker.processor.ProcessorTracker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ProcessorTrackerPool {
    private static final Map<Long, Map<String, ProcessorTracker>> processorTrackerPool = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessorTracker getProcessorTracker(Long instanceId, String address, Supplier<ProcessorTracker> creator) {
        ProcessorTracker processorTracker = (ProcessorTracker)processorTrackerPool.getOrDefault(instanceId, Collections.emptyMap()).get(address);
        if (processorTracker != null) return processorTracker;
        Class<ProcessorTrackerPool> clazz = ProcessorTrackerPool.class;
        synchronized (ProcessorTrackerPool.class) {
            processorTracker = (ProcessorTracker)processorTrackerPool.getOrDefault(instanceId, Collections.emptyMap()).get(address);
            if (processorTracker != null) return processorTracker;
            processorTracker = creator.get();
            processorTrackerPool.computeIfAbsent(instanceId, ignore -> Maps.newHashMap()).put(address, processorTracker);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return processorTracker;
        }
    }

    public static List<ProcessorTracker> removeProcessorTracker(Long instanceId) {
        LinkedList res = Lists.newLinkedList();
        Map<String, ProcessorTracker> ttAddress2Pt = processorTrackerPool.remove(instanceId);
        if (ttAddress2Pt != null) {
            res.addAll(ttAddress2Pt.values());
            ttAddress2Pt.clear();
        }
        return res;
    }
}

