/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.processor.sdk;

import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.common.ThreadLocalStore;
import com.github.kfcfans.powerjob.worker.common.utils.AkkaUtils;
import com.github.kfcfans.powerjob.worker.core.processor.ProcessResult;
import com.github.kfcfans.powerjob.worker.core.processor.sdk.BasicProcessor;
import com.github.kfcfans.powerjob.worker.persistence.TaskDO;
import com.github.kfcfans.powerjob.worker.pojo.request.ProcessorMapTaskRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class MapProcessor
implements BasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(MapProcessor.class);
    private static final int RECOMMEND_BATCH_SIZE = 200;

    public ProcessResult map(List<?> taskList, String taskName) {
        if (CollectionUtils.isEmpty(taskList)) {
            return new ProcessResult(false, "taskList can't be null");
        }
        if (taskList.size() > 200) {
            log.warn("[MapProcessor] map task size is too large, network maybe overload... please try to split the tasks.");
        }
        TaskDO task = ThreadLocalStore.getTask();
        ProcessorMapTaskRequest req = new ProcessorMapTaskRequest(task, taskList, taskName);
        String akkaRemotePath = AkkaUtils.getAkkaWorkerPath(task.getAddress(), "task_tracker");
        boolean requestSucceed = AkkaUtils.reliableTransmit(OhMyWorker.actorSystem.actorSelection(akkaRemotePath), req);
        if (requestSucceed) {
            return new ProcessResult(true, "MAP_SUCCESS");
        }
        log.warn("[MapProcessor] map failed for {}", (Object)taskName);
        return new ProcessResult(false, "MAP_FAILED");
    }

    public boolean isRootTask() {
        TaskDO task = ThreadLocalStore.getTask();
        return "OMS_ROOT_TASK".equals(task.getTaskName());
    }
}

