/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.processor.built;

import com.github.kfcfans.powerjob.worker.common.utils.OmsWorkerFileUtils;
import com.github.kfcfans.powerjob.worker.core.processor.ProcessResult;
import com.github.kfcfans.powerjob.worker.core.processor.TaskContext;
import com.github.kfcfans.powerjob.worker.core.processor.sdk.BasicProcessor;
import com.github.kfcfans.powerjob.worker.log.OmsLogger;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptProcessor
implements BasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(ScriptProcessor.class);
    protected final Long instanceId;
    private final String scriptPath;
    private final long timeout;
    private static final Set<String> DOWNLOAD_PROTOCOL = Sets.newHashSet((Object[])new String[]{"http", "https", "ftp"});

    public ScriptProcessor(Long instanceId, String processorInfo, long timeout) throws Exception {
        this.instanceId = instanceId;
        this.scriptPath = OmsWorkerFileUtils.getScriptDir() + this.genScriptName();
        this.timeout = timeout;
        File script = new File(this.scriptPath);
        if (script.exists()) {
            return;
        }
        File dir = new File(script.getParent());
        boolean success = dir.mkdirs();
        success = script.createNewFile();
        if (!success) {
            throw new RuntimeException("create script file failed");
        }
        for (String protocol : DOWNLOAD_PROTOCOL) {
            if (!processorInfo.startsWith(protocol)) continue;
            FileUtils.copyURLToFile((URL)new URL(processorInfo), (File)script, (int)5000, (int)300000);
            return;
        }
        try (FileWriter fw = new FileWriter(script);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(processorInfo);
            bw.flush();
        }
    }

    @Override
    public ProcessResult process(TaskContext context) throws Exception {
        OmsLogger omsLogger = context.getOmsLogger();
        omsLogger.info("SYSTEM===> ScriptProcessor start to process", new Object[0]);
        ProcessBuilder chmodPb = new ProcessBuilder("/bin/chmod", "755", this.scriptPath);
        chmodPb.start().waitFor();
        ProcessBuilder pb = new ProcessBuilder(this.fetchRunCommand(), this.scriptPath);
        Process process = pb.start();
        StringBuilder inputSB = new StringBuilder();
        StringBuilder errorSB = new StringBuilder();
        new Thread(() -> this.copyStream(process.getInputStream(), inputSB, omsLogger)).start();
        new Thread(() -> this.copyStream(process.getErrorStream(), errorSB, omsLogger)).start();
        try {
            boolean s = process.waitFor(this.timeout, TimeUnit.MILLISECONDS);
            if (!s) {
                omsLogger.info("SYSTEM===> process timeout", new Object[0]);
                return new ProcessResult(false, "TIMEOUT");
            }
            String result = String.format("[INPUT]: %s;[ERROR]: %s", inputSB.toString(), errorSB.toString());
            int exitValue = process.exitValue();
            return new ProcessResult(exitValue == 0, result);
        }
        catch (InterruptedException ie) {
            omsLogger.info("SYSTEM===> ScriptProcessor has been interrupted", new Object[0]);
            return new ProcessResult(false, "Interrupted");
        }
    }

    private void copyStream(InputStream is, StringBuilder sb, OmsLogger omsLogger) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                omsLogger.info(line, new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn("[ScriptProcessor] copyStream failed.", (Throwable)e);
            omsLogger.warn("[ScriptProcessor] copyStream failed.", e);
            sb.append("Exception: ").append(e);
        }
    }

    protected abstract String genScriptName();

    protected abstract String fetchRunCommand();
}

