/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.processor;

import com.github.kfcfans.powerjob.common.utils.JsonUtils;
import com.github.kfcfans.powerjob.worker.log.OmsLogger;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class TaskContext {
    private Long jobId;
    private Long instanceId;
    private Long subInstanceId;
    private String taskId;
    private String taskName;
    private String jobParams;
    private String instanceParams;
    private int maxRetryTimes;
    private int currentRetryTimes;
    private Object subTask;
    private OmsLogger omsLogger;
    private Object userContext;

    public Map<Long, String> fetchUpstreamTaskResult() {
        HashMap res = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)this.instanceParams)) {
            return res;
        }
        try {
            Map originMap = (Map)JsonUtils.parseObject((String)this.instanceParams, Map.class);
            originMap.forEach((k, v) -> res.put(Long.valueOf(String.valueOf(k)), String.valueOf(v)));
            return res;
        }
        catch (Exception exception) {
            return Maps.newHashMap();
        }
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getSubInstanceId() {
        return this.subInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public String getInstanceParams() {
        return this.instanceParams;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public int getCurrentRetryTimes() {
        return this.currentRetryTimes;
    }

    public Object getSubTask() {
        return this.subTask;
    }

    public OmsLogger getOmsLogger() {
        return this.omsLogger;
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setSubInstanceId(Long subInstanceId) {
        this.subInstanceId = subInstanceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public void setInstanceParams(String instanceParams) {
        this.instanceParams = instanceParams;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setCurrentRetryTimes(int currentRetryTimes) {
        this.currentRetryTimes = currentRetryTimes;
    }

    public void setSubTask(Object subTask) {
        this.subTask = subTask;
    }

    public void setOmsLogger(OmsLogger omsLogger) {
        this.omsLogger = omsLogger;
    }

    public void setUserContext(Object userContext) {
        this.userContext = userContext;
    }

    public String toString() {
        return "TaskContext(jobId=" + this.getJobId() + ", instanceId=" + this.getInstanceId() + ", subInstanceId=" + this.getSubInstanceId() + ", taskId=" + this.getTaskId() + ", taskName=" + this.getTaskName() + ", jobParams=" + this.getJobParams() + ", instanceParams=" + this.getInstanceParams() + ", maxRetryTimes=" + this.getMaxRetryTimes() + ", currentRetryTimes=" + this.getCurrentRetryTimes() + ", subTask=" + this.getSubTask() + ", omsLogger=" + this.getOmsLogger() + ", userContext=" + this.getUserContext() + ")";
    }
}

