/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core.ha;

import com.github.kfcfans.powerjob.worker.core.ha.ProcessorTrackerStatus;
import com.github.kfcfans.powerjob.worker.pojo.request.ProcessorTrackerStatusReportReq;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcessorTrackerStatusHolder {
    private final Map<String, ProcessorTrackerStatus> address2Status = Maps.newConcurrentMap();

    public ProcessorTrackerStatusHolder(List<String> allWorkerAddress) {
        allWorkerAddress.forEach(address -> {
            ProcessorTrackerStatus pts = new ProcessorTrackerStatus();
            pts.init((String)address);
            this.address2Status.put((String)address, pts);
        });
    }

    public ProcessorTrackerStatus getProcessorTrackerStatus(String address) {
        return this.address2Status.get(address);
    }

    public void updateStatus(ProcessorTrackerStatusReportReq heartbeatReq) {
        ProcessorTrackerStatus processorTrackerStatus = this.address2Status.get(heartbeatReq.getAddress());
        processorTrackerStatus.update(heartbeatReq);
    }

    public List<String> getAvailableProcessorTrackers() {
        LinkedList result = Lists.newLinkedList();
        this.address2Status.forEach((address, ptStatus) -> {
            if (ptStatus.available()) {
                result.add(address);
            }
        });
        return result;
    }

    public List<String> getAllProcessorTrackers() {
        return Lists.newArrayList(this.address2Status.keySet());
    }

    public List<String> getAllDisconnectedProcessorTrackers() {
        LinkedList result = Lists.newLinkedList();
        this.address2Status.forEach((ip, ptStatus) -> {
            if (ptStatus.isTimeout()) {
                result.add(ip);
            }
        });
        return result;
    }
}

