/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.core;

import com.github.kfcfans.powerjob.worker.core.processor.sdk.BasicProcessor;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessorBeanFactory.class);
    private final Map<String, Map<String, BasicProcessor>> cache = Maps.newConcurrentMap();
    private static final String LOCAL_KEY = "local";
    private static volatile ProcessorBeanFactory processorBeanFactory;

    public ProcessorBeanFactory() {
        ConcurrentMap className2Processor = Maps.newConcurrentMap();
        this.cache.put(LOCAL_KEY, className2Processor);
    }

    public BasicProcessor getLocalProcessor(String className) {
        return this.cache.get(LOCAL_KEY).computeIfAbsent(className, ignore -> {
            try {
                Class<?> clz = Class.forName(className);
                return (BasicProcessor)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("[ProcessorBeanFactory] load local Processor(className = {}) failed, reason is {}", (Object)className, (Object)e.getMessage());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessorBeanFactory getInstance() {
        if (processorBeanFactory != null) {
            return processorBeanFactory;
        }
        Class<ProcessorBeanFactory> clazz = ProcessorBeanFactory.class;
        synchronized (ProcessorBeanFactory.class) {
            if (processorBeanFactory == null) {
                processorBeanFactory = new ProcessorBeanFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return processorBeanFactory;
        }
    }
}

