/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.common.utils;

import org.springframework.context.ApplicationContext;

public class SpringUtils {
    private static boolean supportSpringBean = false;
    private static ApplicationContext context;

    public static void inject(ApplicationContext ctx) {
        context = ctx;
        supportSpringBean = true;
    }

    public static boolean supportSpringBean() {
        return supportSpringBean;
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)context.getBean(clz);
    }

    public static <T> T getBean(String className) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null) {
            return (T)context.getBean(classLoader.loadClass(className));
        }
        String[] split = className.split("\\.");
        String beanName = split[split.length - 1];
        char[] cs = beanName.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        return (T)context.getBean(String.valueOf(cs));
    }
}

