/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.common.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public class SerializerUtils {
    private static final ThreadLocal<Kryo> kryoLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(false);
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        return kryo;
    });

    public static byte[] serialize(Object obj) {
        Kryo kryo = kryoLocal.get();
        try (Output opt = new Output(1024, -1);){
            kryo.writeClassAndObject(opt, obj);
            opt.flush();
            byte[] byArray = opt.getBuffer();
            return byArray;
        }
    }

    public static Object deSerialized(byte[] buffer) {
        Kryo kryo = kryoLocal.get();
        return kryo.readClassAndObject(new Input(buffer));
    }
}

