/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.common.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.function.BiConsumer;

public class LRUCache<K, V> {
    private final Cache<K, V> innerCache;

    public LRUCache(int cacheSize) {
        this.innerCache = CacheBuilder.newBuilder().concurrencyLevel(2).maximumSize((long)cacheSize).build();
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.innerCache.asMap().forEach(action);
    }

    public V get(K key) {
        return (V)this.innerCache.getIfPresent(key);
    }

    public void put(K key, V value) {
        this.innerCache.put(key, value);
    }
}

