/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.common.utils;

import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import com.github.kfcfans.powerjob.common.response.AskResponse;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AkkaUtils {
    private static final Logger log = LoggerFactory.getLogger(AkkaUtils.class);
    private static final String AKKA_NODE_PATH = "akka://%s@%s/user/%s";

    public static String getAkkaWorkerPath(String address, String actorName) {
        return String.format(AKKA_NODE_PATH, "oms", address, actorName);
    }

    public static String getAkkaServerPath(String actorName) {
        if (StringUtils.isEmpty((Object)OhMyWorker.getCurrentServer())) {
            return null;
        }
        return String.format(AKKA_NODE_PATH, "oms-server", OhMyWorker.getCurrentServer(), actorName);
    }

    public static boolean reliableTransmit(ActorSelection remote, Object msg) {
        try {
            CompletionStage ask = Patterns.ask((ActorSelection)remote, (Object)msg, (Duration)Duration.ofMillis(3000L));
            AskResponse response = (AskResponse)ask.toCompletableFuture().get(3000L, TimeUnit.MILLISECONDS);
            return response.isSuccess();
        }
        catch (Exception e) {
            log.warn("[Oms-Transmitter] transmit {} failed, reason is {}", msg, (Object)e.toString());
            return false;
        }
    }
}

