/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.common;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;

public final class OmsWorkerVersion {
    private static String CACHE = null;

    public static String getVersion() {
        if (StringUtils.isEmpty((CharSequence)CACHE)) {
            CACHE = OmsWorkerVersion.determineSpringBootVersion();
        }
        return CACHE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineSpringBootVersion() {
        String implementationVersion = OmsWorkerVersion.class.getPackage().getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        CodeSource codeSource = OmsWorkerVersion.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL codeSourceLocation = codeSource.getLocation();
        try {
            URLConnection connection = codeSourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                return OmsWorkerVersion.getImplementationVersion(((JarURLConnection)connection).getJarFile());
            }
            try (JarFile jarFile = new JarFile(new File(codeSourceLocation.toURI()));){
                String string = OmsWorkerVersion.getImplementationVersion(jarFile);
                return string;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

