/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.background;

import akka.actor.ActorSelection;
import com.github.kfcfans.powerjob.common.model.SystemMetrics;
import com.github.kfcfans.powerjob.common.request.WorkerHeartbeat;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.common.OmsWorkerVersion;
import com.github.kfcfans.powerjob.worker.common.utils.AkkaUtils;
import com.github.kfcfans.powerjob.worker.common.utils.SystemInfoUtils;
import com.github.kfcfans.powerjob.worker.container.OmsContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class WorkerHealthReporter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkerHealthReporter.class);

    @Override
    public void run() {
        String currentServer = OhMyWorker.getCurrentServer();
        if (StringUtils.isEmpty((Object)currentServer)) {
            return;
        }
        SystemMetrics systemMetrics = SystemInfoUtils.getSystemMetrics();
        WorkerHeartbeat heartbeat = new WorkerHeartbeat();
        heartbeat.setSystemMetrics(systemMetrics);
        heartbeat.setWorkerAddress(OhMyWorker.getWorkerAddress());
        heartbeat.setAppName(OhMyWorker.getConfig().getAppName());
        heartbeat.setAppId(OhMyWorker.getAppId());
        heartbeat.setHeartbeatTime(System.currentTimeMillis());
        heartbeat.setVersion(OmsWorkerVersion.getVersion());
        heartbeat.setContainerInfos(OmsContainerFactory.getDeployedContainerInfos());
        String serverPath = AkkaUtils.getAkkaServerPath("server_actor");
        if (StringUtils.isEmpty((Object)serverPath)) {
            return;
        }
        ActorSelection actorSelection = OhMyWorker.actorSystem.actorSelection(serverPath);
        actorSelection.tell((Object)heartbeat, null);
    }
}

