/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.background;

import com.github.kfcfans.powerjob.common.response.ResultDTO;
import com.github.kfcfans.powerjob.common.utils.CommonUtils;
import com.github.kfcfans.powerjob.common.utils.HttpUtils;
import com.github.kfcfans.powerjob.common.utils.JsonUtils;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.core.tracker.task.TaskTracker;
import com.github.kfcfans.powerjob.worker.core.tracker.task.TaskTrackerPool;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ServerDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(ServerDiscoveryService.class);
    private static final Map<String, String> IP2ADDRESS = Maps.newHashMap();
    private static final String DISCOVERY_URL = "http://%s/server/acquire?appId=%d&currentServer=%s";
    private static int FAILED_COUNT = 0;
    private static final int MAX_FAILED_COUNT = 3;

    public static String discovery() {
        Object ip;
        String firstServerAddress;
        if (IP2ADDRESS.isEmpty()) {
            OhMyWorker.getConfig().getServerAddress().forEach(x -> IP2ADDRESS.put(x.split(":")[0], (String)x));
        }
        String result = null;
        String currentServer = OhMyWorker.getCurrentServer();
        if (!StringUtils.isEmpty((Object)currentServer) && (firstServerAddress = IP2ADDRESS.get(ip = currentServer.split(":")[0])) != null) {
            result = ServerDiscoveryService.acquire(firstServerAddress);
        }
        for (String httpServerAddress : OhMyWorker.getConfig().getServerAddress()) {
            if (!StringUtils.isEmpty(result)) break;
            result = ServerDiscoveryService.acquire(httpServerAddress);
        }
        if (StringUtils.isEmpty(result)) {
            log.warn("[OmsServerDiscovery] can't find any available server, this worker has been quarantined.");
            if (FAILED_COUNT++ > 3) {
                log.warn("[OmsServerDiscovery] can't find any available server for 3 consecutive times, It's time to kill all frequent job in this worker.");
                List<Long> frequentInstanceIds = TaskTrackerPool.getAllFrequentTaskTrackerKeys();
                if (!CollectionUtils.isEmpty(frequentInstanceIds)) {
                    frequentInstanceIds.forEach(instanceId -> {
                        TaskTracker taskTracker = TaskTrackerPool.remove(instanceId);
                        taskTracker.destroy();
                        log.warn("[OmsServerDiscovery] kill frequent instance(instanceId={}) due to can't find any available server.", instanceId);
                    });
                }
                FAILED_COUNT = 0;
            }
            return null;
        }
        FAILED_COUNT = 0;
        log.debug("[OmsServerDiscovery] current server is {}.", (Object)result);
        return result;
    }

    private static String acquire(String httpServerAddress) {
        String result = null;
        String url = String.format(DISCOVERY_URL, httpServerAddress, OhMyWorker.getAppId(), OhMyWorker.getCurrentServer());
        try {
            result = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(result)) {
            try {
                ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)result, ResultDTO.class);
                if (resultDTO.isSuccess()) {
                    return resultDTO.getData().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

