/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.background;

import akka.actor.ActorSelection;
import com.github.kfcfans.powerjob.common.model.InstanceLogContent;
import com.github.kfcfans.powerjob.common.request.WorkerLogReportReq;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.common.utils.AkkaUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OmsLogHandler {
    private static final Logger log = LoggerFactory.getLogger(OmsLogHandler.class);
    public static final OmsLogHandler INSTANCE = new OmsLogHandler();
    private final BlockingQueue<InstanceLogContent> logQueue = Queues.newLinkedBlockingQueue();
    public final Runnable logSubmitter = new LogSubmitter();
    private final Lock reportLock = new ReentrantLock();
    private static final int BATCH_SIZE = 20;
    private static final int REPORT_SIZE = 1024;

    private OmsLogHandler() {
    }

    public void submitLog(long instanceId, String logContent) {
        if (this.logQueue.size() > 1024) {
            new Thread(this.logSubmitter).start();
        }
        InstanceLogContent tuple = new InstanceLogContent(instanceId, System.currentTimeMillis(), logContent);
        this.logQueue.offer(tuple);
    }

    private class LogSubmitter
    implements Runnable {
        private LogSubmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean lockResult = OmsLogHandler.this.reportLock.tryLock();
            if (!lockResult) {
                return;
            }
            try {
                String serverPath = AkkaUtils.getAkkaServerPath("server_actor");
                if (StringUtils.isEmpty((Object)serverPath)) {
                    if (!OmsLogHandler.this.logQueue.isEmpty()) {
                        OmsLogHandler.this.logQueue.clear();
                        log.warn("[OmsLogHandler] because there is no available server to report logs which leads to queue accumulation, oms discarded all logs.");
                    }
                    return;
                }
                ActorSelection serverActor = OhMyWorker.actorSystem.actorSelection(serverPath);
                LinkedList logs = Lists.newLinkedList();
                while (!OmsLogHandler.this.logQueue.isEmpty()) {
                    try {
                        InstanceLogContent logContent = (InstanceLogContent)OmsLogHandler.this.logQueue.poll(100L, TimeUnit.MILLISECONDS);
                        logs.add(logContent);
                        if (logs.size() < 20) continue;
                        WorkerLogReportReq req = new WorkerLogReportReq(OhMyWorker.getWorkerAddress(), (List)Lists.newLinkedList((Iterable)logs));
                        serverActor.tell((Object)req, null);
                        logs.clear();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                        break;
                    }
                }
                if (!logs.isEmpty()) {
                    WorkerLogReportReq req = new WorkerLogReportReq(OhMyWorker.getWorkerAddress(), (List)logs);
                    serverActor.tell((Object)req, null);
                }
            }
            finally {
                OmsLogHandler.this.reportLock.unlock();
            }
        }
    }
}

