/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.actors;

import akka.actor.AbstractActor;
import com.github.kfcfans.powerjob.common.request.ServerDeployContainerRequest;
import com.github.kfcfans.powerjob.common.request.ServerDestroyContainerRequest;
import com.github.kfcfans.powerjob.worker.container.OmsContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(WorkerActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ServerDeployContainerRequest.class, this::onReceiveServerDeployContainerRequest).match(ServerDestroyContainerRequest.class, this::onReceiveServerDestroyContainerRequest).matchAny(obj -> log.warn("[WorkerActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveServerDeployContainerRequest(ServerDeployContainerRequest request) {
        OmsContainerFactory.deployContainer(request);
    }

    private void onReceiveServerDestroyContainerRequest(ServerDestroyContainerRequest request) {
        OmsContainerFactory.destroyContainer(request.getContainerId());
    }
}

