/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.actors;

import akka.actor.AbstractActor;
import com.github.kfcfans.powerjob.worker.core.tracker.processor.ProcessorTracker;
import com.github.kfcfans.powerjob.worker.core.tracker.processor.ProcessorTrackerPool;
import com.github.kfcfans.powerjob.worker.persistence.TaskDO;
import com.github.kfcfans.powerjob.worker.pojo.request.TaskTrackerStartTaskReq;
import com.github.kfcfans.powerjob.worker.pojo.request.TaskTrackerStopInstanceReq;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ProcessorTrackerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(ProcessorTrackerActor.class);

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(TaskTrackerStartTaskReq.class, this::onReceiveTaskTrackerStartTaskReq).match(TaskTrackerStopInstanceReq.class, this::onReceiveTaskTrackerStopInstanceReq).matchAny(obj -> log.warn("[ProcessorTrackerActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveTaskTrackerStartTaskReq(TaskTrackerStartTaskReq req) {
        Long instanceId = req.getInstanceInfo().getInstanceId();
        ProcessorTracker processorTracker = ProcessorTrackerPool.getProcessorTracker(instanceId, req.getTaskTrackerAddress(), () -> new ProcessorTracker(req));
        TaskDO task = new TaskDO();
        task.setTaskId(req.getTaskId());
        task.setTaskName(req.getTaskName());
        task.setTaskContent(req.getTaskContent());
        task.setFailedCnt(req.getTaskCurrentRetryNums());
        task.setSubInstanceId(req.getSubInstanceId());
        processorTracker.submitTask(task);
    }

    private void onReceiveTaskTrackerStopInstanceReq(TaskTrackerStopInstanceReq req) {
        Long instanceId = req.getInstanceId();
        List<ProcessorTracker> removedPts = ProcessorTrackerPool.removeProcessorTracker(instanceId);
        if (!CollectionUtils.isEmpty(removedPts)) {
            removedPts.forEach(ProcessorTracker::destroy);
        }
    }
}

