/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import akka.routing.RoundRobinPool;
import akka.routing.RouterConfig;
import com.github.kfcfans.powerjob.common.OmsException;
import com.github.kfcfans.powerjob.common.response.ResultDTO;
import com.github.kfcfans.powerjob.common.utils.CommonUtils;
import com.github.kfcfans.powerjob.common.utils.HttpUtils;
import com.github.kfcfans.powerjob.common.utils.JsonUtils;
import com.github.kfcfans.powerjob.common.utils.NetUtils;
import com.github.kfcfans.powerjob.worker.actors.ProcessorTrackerActor;
import com.github.kfcfans.powerjob.worker.actors.TaskTrackerActor;
import com.github.kfcfans.powerjob.worker.actors.TroubleshootingActor;
import com.github.kfcfans.powerjob.worker.actors.WorkerActor;
import com.github.kfcfans.powerjob.worker.background.OmsLogHandler;
import com.github.kfcfans.powerjob.worker.background.ServerDiscoveryService;
import com.github.kfcfans.powerjob.worker.background.WorkerHealthReporter;
import com.github.kfcfans.powerjob.worker.common.OhMyConfig;
import com.github.kfcfans.powerjob.worker.common.OmsBannerPrinter;
import com.github.kfcfans.powerjob.worker.common.utils.SpringUtils;
import com.github.kfcfans.powerjob.worker.persistence.TaskPersistenceService;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class OhMyWorker
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(OhMyWorker.class);
    private static OhMyConfig config;
    private static String currentServer;
    private static String workerAddress;
    public static ActorSystem actorSystem;
    private static Long appId;
    private static ScheduledExecutorService timingPool;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.inject(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[OhMyWorker] start to initialize OhMyWorker...");
        try {
            OmsBannerPrinter.print();
            if (!config.isEnableTestMode()) {
                appId = this.assertAppName();
            } else {
                log.warn("[OhMyWorker] using TestMode now, it's dangerous if this is production env.");
            }
            HashMap overrideConfig = Maps.newHashMap();
            overrideConfig.put("akka.remote.artery.canonical.hostname", NetUtils.getLocalHost());
            overrideConfig.put("akka.remote.artery.canonical.port", config.getPort());
            workerAddress = NetUtils.getLocalHost() + ":" + config.getPort();
            Config akkaBasicConfig = ConfigFactory.load((String)"oms-worker.akka.conf");
            Config akkaFinalConfig = ConfigFactory.parseMap((Map)overrideConfig).withFallback((ConfigMergeable)akkaBasicConfig);
            int cores = Runtime.getRuntime().availableProcessors();
            actorSystem = ActorSystem.create((String)"oms", (Config)akkaFinalConfig);
            actorSystem.actorOf(Props.create(TaskTrackerActor.class, (Object[])new Object[0]).withDispatcher("akka.task-tracker-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores * 2)), "task_tracker");
            actorSystem.actorOf(Props.create(ProcessorTrackerActor.class, (Object[])new Object[0]).withDispatcher("akka.processor-tracker-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores)), "processor_tracker");
            actorSystem.actorOf(Props.create(WorkerActor.class, (Object[])new Object[0]).withDispatcher("akka.worker-common-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores)), "worker");
            ActorRef troubleshootingActor = actorSystem.actorOf(Props.create(TroubleshootingActor.class, (Object[])new Object[0]), "troubleshooting");
            actorSystem.eventStream().subscribe(troubleshootingActor, DeadLetter.class);
            log.info("[OhMyWorker] akka-remote listening address: {}", (Object)workerAddress);
            log.info("[OhMyWorker] akka ActorSystem({}) initialized successfully.", (Object)actorSystem);
            TaskPersistenceService.INSTANCE.init();
            log.info("[OhMyWorker] local storage initialized successfully.");
            currentServer = ServerDiscoveryService.discovery();
            if (StringUtils.isEmpty((Object)currentServer) && !config.isEnableTestMode()) {
                throw new RuntimeException("can't find any available server, this worker has been quarantined.");
            }
            log.info("[OhMyWorker] discovery server succeed, current server is {}.", (Object)currentServer);
            ThreadFactory timingPoolFactory = new ThreadFactoryBuilder().setNameFormat("oms-worker-timing-pool-%d").build();
            timingPool = Executors.newScheduledThreadPool(3, timingPoolFactory);
            timingPool.scheduleAtFixedRate(new WorkerHealthReporter(), 0L, 15L, TimeUnit.SECONDS);
            timingPool.scheduleAtFixedRate(() -> {
                currentServer = ServerDiscoveryService.discovery();
            }, 10L, 10L, TimeUnit.SECONDS);
            timingPool.scheduleWithFixedDelay(OmsLogHandler.INSTANCE.logSubmitter, 0L, 5L, TimeUnit.SECONDS);
            log.info("[OhMyWorker] OhMyWorker initialized successfully, using time: {}, congratulations!", (Object)stopwatch);
        }
        catch (Exception e) {
            log.error("[OhMyWorker] initialize OhMyWorker failed, using {}.", (Object)stopwatch, (Object)e);
            throw e;
        }
    }

    public void setConfig(OhMyConfig config) {
        OhMyWorker.config = config;
    }

    private Long assertAppName() {
        String appName = config.getAppName();
        Objects.requireNonNull(appName, "appName can't be empty!");
        String url = "http://%s/server/assert?appName=%s";
        for (String server : config.getServerAddress()) {
            String realUrl = String.format(url, server, appName);
            try {
                String resultDTOStr = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)realUrl));
                ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)resultDTOStr, ResultDTO.class);
                if (resultDTO.isSuccess()) {
                    Long appId = Long.valueOf(resultDTO.getData().toString());
                    log.info("[OhMyWorker] assert appName({}) succeed, the appId for this application is {}.", (Object)appName, (Object)appId);
                    return appId;
                }
                log.error("[OhMyWorker] assert appName failed, this appName is invalid, please register the appName {} first.", (Object)appName);
                throw new OmsException(resultDTO.getMessage());
            }
            catch (OmsException oe) {
                throw oe;
            }
            catch (Exception ignore) {
                log.warn("[OhMyWorker] assert appName by url({}) failed, please check the server address.", (Object)realUrl);
            }
        }
        log.error("[OhMyWorker] no available server in {}.", config.getServerAddress());
        throw new OmsException("no server available!");
    }

    public void destroy() throws Exception {
        timingPool.shutdownNow();
    }

    public static OhMyConfig getConfig() {
        return config;
    }

    public static String getCurrentServer() {
        return currentServer;
    }

    public static String getWorkerAddress() {
        return workerAddress;
    }

    public static Long getAppId() {
        return appId;
    }
}

