/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.common.utils;

import com.github.kfcfans.powerjob.common.utils.CommonUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SegmentLock {
    private final int mask;
    private final Lock[] locks;

    public SegmentLock(int concurrency) {
        int size = CommonUtils.formatSize(concurrency);
        this.mask = size - 1;
        this.locks = new Lock[size];
        for (int i = 0; i < size; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public void lockInterruptible(int lockId) throws InterruptedException {
        Lock lock = this.locks[lockId & this.mask];
        lock.lockInterruptibly();
    }

    public void lockInterruptibleSafe(int lockId) {
        try {
            this.lockInterruptible(lockId);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void unlock(int lockId) {
        Lock lock = this.locks[lockId & this.mask];
        lock.unlock();
    }
}

