/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.common.utils;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();
    private static final int HTTP_SUCCESS_CODE = 200;

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                String string = Objects.requireNonNull(response.body()).string();
                return string;
            }
        }
        return null;
    }

    public static String post(String url, RequestBody requestBody) throws IOException {
        Request request = new Request.Builder().post(requestBody).url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                String string = Objects.requireNonNull(response.body()).string();
                return string;
            }
        }
        return null;
    }
}

