/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.common.model;

import com.github.kfcfans.powerjob.common.OmsSerializable;

public class SystemMetrics
implements OmsSerializable,
Comparable<SystemMetrics> {
    private int cpuProcessors;
    private double cpuLoad;
    private double jvmUsedMemory;
    private double jvmMaxMemory;
    private double jvmMemoryUsage;
    private double diskUsed;
    private double diskTotal;
    private double diskUsage;
    private int score;

    @Override
    public int compareTo(SystemMetrics that) {
        return that.calculateScore() - this.calculateScore();
    }

    public int calculateScore() {
        if (this.score > 0) {
            return this.score;
        }
        double memScore = (this.jvmMaxMemory - this.jvmUsedMemory) * 2.0;
        double cpuScore = (double)this.cpuProcessors - this.cpuLoad;
        if (cpuScore > (double)this.cpuProcessors) {
            cpuScore = 1.0;
        }
        this.score = (int)(memScore + cpuScore);
        return this.score;
    }

    public boolean available(double minCPUCores, double minMemorySpace, double minDiskSpace) {
        double availableMemory = this.jvmMaxMemory - this.jvmUsedMemory;
        double availableDisk = this.diskTotal - this.diskUsed;
        if (availableMemory < minMemorySpace || availableDisk < minDiskSpace) {
            return false;
        }
        if (this.cpuLoad <= 0.0 || minCPUCores <= 0.0) {
            return true;
        }
        return minCPUCores < (double)this.cpuProcessors - this.cpuLoad;
    }

    public int getCpuProcessors() {
        return this.cpuProcessors;
    }

    public double getCpuLoad() {
        return this.cpuLoad;
    }

    public double getJvmUsedMemory() {
        return this.jvmUsedMemory;
    }

    public double getJvmMaxMemory() {
        return this.jvmMaxMemory;
    }

    public double getJvmMemoryUsage() {
        return this.jvmMemoryUsage;
    }

    public double getDiskUsed() {
        return this.diskUsed;
    }

    public double getDiskTotal() {
        return this.diskTotal;
    }

    public double getDiskUsage() {
        return this.diskUsage;
    }

    public int getScore() {
        return this.score;
    }

    public void setCpuProcessors(int cpuProcessors) {
        this.cpuProcessors = cpuProcessors;
    }

    public void setCpuLoad(double cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public void setJvmUsedMemory(double jvmUsedMemory) {
        this.jvmUsedMemory = jvmUsedMemory;
    }

    public void setJvmMaxMemory(double jvmMaxMemory) {
        this.jvmMaxMemory = jvmMaxMemory;
    }

    public void setJvmMemoryUsage(double jvmMemoryUsage) {
        this.jvmMemoryUsage = jvmMemoryUsage;
    }

    public void setDiskUsed(double diskUsed) {
        this.diskUsed = diskUsed;
    }

    public void setDiskTotal(double diskTotal) {
        this.diskTotal = diskTotal;
    }

    public void setDiskUsage(double diskUsage) {
        this.diskUsage = diskUsage;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemMetrics)) {
            return false;
        }
        SystemMetrics other = (SystemMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCpuProcessors() != other.getCpuProcessors()) {
            return false;
        }
        if (Double.compare(this.getCpuLoad(), other.getCpuLoad()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmUsedMemory(), other.getJvmUsedMemory()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMaxMemory(), other.getJvmMaxMemory()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMemoryUsage(), other.getJvmMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsed(), other.getDiskUsed()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskTotal(), other.getDiskTotal()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsage(), other.getDiskUsage()) != 0) {
            return false;
        }
        return this.getScore() == other.getScore();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCpuProcessors();
        long $cpuLoad = Double.doubleToLongBits(this.getCpuLoad());
        result = result * 59 + (int)($cpuLoad >>> 32 ^ $cpuLoad);
        long $jvmUsedMemory = Double.doubleToLongBits(this.getJvmUsedMemory());
        result = result * 59 + (int)($jvmUsedMemory >>> 32 ^ $jvmUsedMemory);
        long $jvmMaxMemory = Double.doubleToLongBits(this.getJvmMaxMemory());
        result = result * 59 + (int)($jvmMaxMemory >>> 32 ^ $jvmMaxMemory);
        long $jvmMemoryUsage = Double.doubleToLongBits(this.getJvmMemoryUsage());
        result = result * 59 + (int)($jvmMemoryUsage >>> 32 ^ $jvmMemoryUsage);
        long $diskUsed = Double.doubleToLongBits(this.getDiskUsed());
        result = result * 59 + (int)($diskUsed >>> 32 ^ $diskUsed);
        long $diskTotal = Double.doubleToLongBits(this.getDiskTotal());
        result = result * 59 + (int)($diskTotal >>> 32 ^ $diskTotal);
        long $diskUsage = Double.doubleToLongBits(this.getDiskUsage());
        result = result * 59 + (int)($diskUsage >>> 32 ^ $diskUsage);
        result = result * 59 + this.getScore();
        return result;
    }

    public String toString() {
        return "SystemMetrics(cpuProcessors=" + this.getCpuProcessors() + ", cpuLoad=" + this.getCpuLoad() + ", jvmUsedMemory=" + this.getJvmUsedMemory() + ", jvmMaxMemory=" + this.getJvmMaxMemory() + ", jvmMemoryUsage=" + this.getJvmMemoryUsage() + ", diskUsed=" + this.getDiskUsed() + ", diskTotal=" + this.getDiskTotal() + ", diskUsage=" + this.getDiskUsage() + ", score=" + this.getScore() + ")";
    }
}

